/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.samples.lcm;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.CollectionHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.RegistryHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.ResourceHostObject;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

public class DistributedLCM
extends Aspect {
    private static final Log log = LogFactory.getLog(DistributedLCM.class);
    public static final String PROMOTE = "promote";
    public static final String DEMOTE = "demote";
    public static final String ITEM_CLICK = "itemClick";
    private List<String> states = new ArrayList<String>();
    private List<String> distributedLocations = new ArrayList<String>();
    private List<String> distributedRoles = new ArrayList<String>();
    private List<String> distributedActionPermissions = new ArrayList<String>();
    private Map<String, List<Condition>> transitions = new HashMap<String, List<Condition>>();
    private String stateProperty = "registry.lifecycle.SoftwareProjectLifecycle.state";
    private String lastStateProperty = "registry.dlcm.last.state";
    private String lifecycleProperty = "registry.LC.name";
    boolean isConfigurationFromResource = false;
    boolean configurationFromResourceExtracted = false;
    String configurationResourcePath = "";
    OMElement configurationElement = null;
    String aspectName = "Software Project Lifecycle";

    public DistributedLCM() {
        this.states.add("Design");
        this.states.add("Development");
        this.states.add("Testing");
        this.states.add("Production");
        this.states.add("Deprecated");
    }

    public DistributedLCM(OMElement config) throws RegistryException {
        String myName;
        this.aspectName = myName = config.getAttributeValue(new QName("name"));
        myName = myName.replaceAll("\\s", "");
        this.stateProperty = "registry.lifecycle." + myName + ".state";
        Iterator stateElements = config.getChildElements();
        while (stateElements.hasNext()) {
            String name;
            OMElement stateEl = (OMElement)stateElements.next();
            if (stateEl.getAttribute(new QName("type")) != null) {
                String type = stateEl.getAttributeValue(new QName("type"));
                if (type.equalsIgnoreCase("resource")) {
                    this.isConfigurationFromResource = true;
                    this.configurationResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)stateEl.getText());
                    this.states.clear();
                    this.distributedLocations.clear();
                    this.distributedRoles.clear();
                    this.distributedActionPermissions.clear();
                    this.transitions.clear();
                    break;
                }
                if (type.equalsIgnoreCase("literal")) {
                    this.isConfigurationFromResource = false;
                    this.configurationElement = stateEl.getFirstElement();
                    this.states.clear();
                    this.transitions.clear();
                    this.distributedLocations.clear();
                    this.distributedRoles.clear();
                    this.distributedActionPermissions.clear();
                    break;
                }
            }
            if ((name = stateEl.getAttributeValue(new QName("name"))) == null) {
                throw new IllegalArgumentException("Must have a name attribute for each state");
            }
            this.states.add(name);
            ArrayList<Condition> conditions = null;
            Iterator conditionIterator = stateEl.getChildElements();
            while (conditionIterator.hasNext()) {
                OMElement conditionEl = (OMElement)conditionIterator.next();
                if (!conditionEl.getQName().equals(new QName("condition"))) continue;
                String property = conditionEl.getAttributeValue(new QName("property"));
                String condition = conditionEl.getAttributeValue(new QName("condition"));
                String value = conditionEl.getAttributeValue(new QName("value"));
                Condition c = new Condition(property, condition, value);
                if (conditions == null) {
                    conditions = new ArrayList<Condition>();
                }
                conditions.add(c);
            }
            if (conditions == null) continue;
            this.transitions.put(name, conditions);
        }
    }

    public void associate(Resource resource, Registry registry) throws RegistryException {
        this.states.clear();
        this.distributedLocations.clear();
        this.distributedRoles.clear();
        this.distributedActionPermissions.clear();
        try {
            boolean addStates;
            String xmlContent = "";
            if (this.isConfigurationFromResource) {
                Resource configurationResource = registry.get(this.configurationResourcePath);
                xmlContent = new String((byte[])configurationResource.getContent());
                this.configurationElement = AXIOMUtil.stringToOM((String)xmlContent);
            }
            Iterator stateElements = this.configurationElement.getChildElements();
            int propertyOrder = 0;
            boolean bl = addStates = this.states.size() == 0;
            while (stateElements.hasNext()) {
                OMElement stateEl = (OMElement)stateElements.next();
                String name = stateEl.getAttributeValue(new QName("name"));
                String location = stateEl.getAttributeValue(new QName("location"));
                String roles = stateEl.getAttributeValue(new QName("roles"));
                if (name == null) {
                    throw new IllegalArgumentException("Must have a name attribute for each state");
                }
                if (addStates) {
                    this.states.add(name);
                }
                if (location != null) {
                    if (!this.isValidRegistryCollection(location)) {
                        throw new IllegalArgumentException("The location " + location + ", is not valid.");
                    }
                    if (!location.endsWith("/")) {
                        location = location + "/";
                    }
                    this.distributedLocations.add(RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)location));
                } else {
                    this.distributedLocations.add("#");
                }
                if (roles != null) {
                    this.distributedRoles.add(roles);
                } else {
                    this.distributedRoles.add("#");
                }
                String promoteRoles = "#";
                String demoteRoles = "#";
                Iterator checkListIterator = stateEl.getChildElements();
                int checklistItemOrder = 0;
                while (checkListIterator.hasNext()) {
                    OMElement itemEl = (OMElement)checkListIterator.next();
                    if (itemEl.getQName().equals(new QName("checkitem"))) {
                        ArrayList<String> items = new ArrayList<String>();
                        String itemName = itemEl.getText();
                        if (itemName == null) {
                            throw new RegistryException("Checklist items should have a name!");
                        }
                        items.add("status:" + name);
                        items.add("name:" + itemName);
                        items.add("value:false");
                        if (itemEl.getAttribute(new QName("order")) != null) {
                            items.add("order:" + itemEl.getAttributeValue(new QName("order")));
                        } else {
                            items.add("order:" + checklistItemOrder);
                        }
                        String resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.option" + propertyOrder + ".item";
                        resource.setProperty(resourcePropertyNameForItem, items);
                        ++checklistItemOrder;
                        ++propertyOrder;
                        continue;
                    }
                    if (itemEl.getQName().equals(new QName("permissions"))) {
                        Iterator permissionIterator = itemEl.getChildElements();
                        while (permissionIterator.hasNext()) {
                            OMElement permissionItemEl = (OMElement)permissionIterator.next();
                            if (!permissionItemEl.getQName().equals(new QName("permission"))) continue;
                            String action = permissionItemEl.getAttributeValue(new QName("action"));
                            if (action.toLowerCase().equals(PROMOTE)) {
                                promoteRoles = permissionItemEl.getAttributeValue(new QName("roles"));
                                continue;
                            }
                            if (!action.toLowerCase().equals(DEMOTE)) continue;
                            demoteRoles = permissionItemEl.getAttributeValue(new QName("roles"));
                        }
                        continue;
                    }
                    if (!itemEl.getQName().equals(new QName("js"))) continue;
                    Iterator scriptElementIterator = itemEl.getChildElements();
                    while (scriptElementIterator.hasNext()) {
                        OMElement serverScriptItemEl;
                        String resourcePropertyNameForItem;
                        ArrayList<String> items;
                        String lifecycleScriptCommand;
                        String lifecycleScript;
                        OMElement scriptItemEl = (OMElement)scriptElementIterator.next();
                        if (scriptItemEl.getQName().equals(new QName("console"))) {
                            lifecycleScript = "";
                            lifecycleScriptCommand = "";
                            Iterator consoleScriptElementIterator = scriptItemEl.getChildElements();
                            while (consoleScriptElementIterator.hasNext()) {
                                OMElement consoleScriptItemEl = (OMElement)consoleScriptElementIterator.next();
                                if (!consoleScriptItemEl.getQName().equals(new QName("script"))) continue;
                                lifecycleScript = lifecycleScript + consoleScriptItemEl.toString() + "\n";
                            }
                            if (scriptItemEl.getAttribute(new QName("demoteFunction")) != null) {
                                lifecycleScriptCommand = scriptItemEl.getAttributeValue(new QName("demoteFunction"));
                                items = new ArrayList<String>();
                                items.add(lifecycleScript);
                                items.add(lifecycleScriptCommand);
                                resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.js.script.console." + name + "." + DEMOTE;
                                resource.setProperty(resourcePropertyNameForItem, items);
                            }
                            if (scriptItemEl.getAttribute(new QName("promoteFunction")) == null) continue;
                            lifecycleScriptCommand = scriptItemEl.getAttributeValue(new QName("promoteFunction"));
                            items = new ArrayList();
                            items.add(lifecycleScript);
                            items.add(lifecycleScriptCommand);
                            resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.js.script.console." + name + "." + PROMOTE;
                            resource.setProperty(resourcePropertyNameForItem, items);
                            continue;
                        }
                        if (!scriptItemEl.getQName().equals(new QName("server"))) continue;
                        lifecycleScript = "";
                        lifecycleScriptCommand = "";
                        Iterator serverScriptElementIterator = scriptItemEl.getChildElements();
                        if (serverScriptElementIterator.hasNext() && (serverScriptItemEl = (OMElement)serverScriptElementIterator.next()).getQName().equals(new QName("script"))) {
                            lifecycleScript = lifecycleScript + serverScriptItemEl.getText();
                            lifecycleScript = lifecycleScript.trim();
                        }
                        if (scriptItemEl.getAttribute(new QName("demoteFunction")) != null) {
                            lifecycleScriptCommand = scriptItemEl.getAttributeValue(new QName("demoteFunction"));
                            items = new ArrayList();
                            items.add(lifecycleScript);
                            items.add(lifecycleScriptCommand);
                            resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.js.script.server." + name + "." + DEMOTE;
                            resource.setProperty(resourcePropertyNameForItem, items);
                        }
                        if (scriptItemEl.getAttribute(new QName("promoteFunction")) == null) continue;
                        lifecycleScriptCommand = scriptItemEl.getAttributeValue(new QName("promoteFunction"));
                        items = new ArrayList();
                        items.add(lifecycleScript);
                        items.add(lifecycleScriptCommand);
                        resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.js.script.server." + name + "." + PROMOTE;
                        resource.setProperty(resourcePropertyNameForItem, items);
                    }
                }
                if (promoteRoles.equals("#") && demoteRoles.equals("#")) {
                    this.distributedActionPermissions.add("#");
                    continue;
                }
                this.distributedActionPermissions.add(promoteRoles + ":" + demoteRoles);
            }
        }
        catch (XMLStreamException e) {
            throw new RegistryException("Resource does not contain a valid XML configuration: " + e.toString());
        }
        resource.setProperty(this.stateProperty, this.states.get(0));
        resource.setProperty(this.lifecycleProperty, this.aspectName);
        resource.setProperty(this.lastStateProperty, this.states.get(this.states.size() - 1));
    }

    public String[] getAvailableActions(RequestContext context) {
        String roleName;
        String[] roles;
        int stateIndex;
        try {
            if (this.states.size() == 0) {
                this.distributedLocations.clear();
                this.distributedRoles.clear();
                this.distributedActionPermissions.clear();
                Registry registry = context.getRegistry();
                String xmlContent = "";
                if (this.isConfigurationFromResource) {
                    Resource configurationResource = registry.get(this.configurationResourcePath);
                    xmlContent = new String((byte[])configurationResource.getContent());
                    this.configurationElement = AXIOMUtil.stringToOM((String)xmlContent);
                }
                Iterator stateElements = this.configurationElement.getChildElements();
                while (stateElements.hasNext()) {
                    OMElement stateEl = (OMElement)stateElements.next();
                    String name = stateEl.getAttributeValue(new QName("name"));
                    String location = stateEl.getAttributeValue(new QName("location"));
                    String roles2 = stateEl.getAttributeValue(new QName("roles"));
                    if (name == null) {
                        throw new IllegalArgumentException("Must have a name attribute for each state");
                    }
                    this.states.add(name);
                    if (location != null) {
                        if (!this.isValidRegistryCollection(location)) {
                            throw new IllegalArgumentException("The location " + location + ", is not valid.");
                        }
                        if (!location.endsWith("/")) {
                            location = location + "/";
                        }
                        this.distributedLocations.add(location);
                    } else {
                        this.distributedLocations.add("#");
                    }
                    if (roles2 != null) {
                        this.distributedRoles.add(roles2);
                    } else {
                        this.distributedRoles.add("#");
                    }
                    String promoteRoles = "#";
                    String demoteRoles = "#";
                    Iterator checkListIterator = stateEl.getChildElements();
                    while (checkListIterator.hasNext()) {
                        OMElement itemEl = (OMElement)checkListIterator.next();
                        if (!itemEl.getQName().equals(new QName("permissions"))) continue;
                        Iterator permissionIterator = itemEl.getChildElements();
                        while (permissionIterator.hasNext()) {
                            OMElement permissionItemEl = (OMElement)permissionIterator.next();
                            if (!permissionItemEl.getQName().equals(new QName("permission"))) continue;
                            String action = permissionItemEl.getAttributeValue(new QName("action"));
                            if (action.toLowerCase().equals(PROMOTE)) {
                                promoteRoles = permissionItemEl.getAttributeValue(new QName("roles"));
                                continue;
                            }
                            if (!action.toLowerCase().equals(DEMOTE)) continue;
                            demoteRoles = permissionItemEl.getAttributeValue(new QName("roles"));
                        }
                    }
                    if (promoteRoles.equals("#") && demoteRoles.equals("#")) {
                        this.distributedActionPermissions.add("#");
                        continue;
                    }
                    this.distributedActionPermissions.add(promoteRoles + ":" + demoteRoles);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Resource does not contain a valid XML configuration: " + e.toString());
        }
        ArrayList<String> actions = new ArrayList<String>();
        Resource resource = context.getResource();
        String currentState = resource.getProperty(this.stateProperty);
        Properties props = resource.getProperties();
        Iterator<Object> iKeys = props.keySet().iterator();
        boolean allItemsAreChecked = true;
        while (iKeys.hasNext()) {
            String propKey = (String)iKeys.next();
            if (!propKey.startsWith("registry.custom_lifecycle.checklist.")) continue;
            List propValues = (List)props.get(propKey);
            String[] propertyValues = propValues.toArray(new String[propValues.size()]);
            String itemLifeCycleState = null;
            String itemValue = null;
            if (propertyValues != null) {
                for (int index = 0; index < propertyValues.length; ++index) {
                    String item = propertyValues[index];
                    if (itemLifeCycleState == null && item.startsWith("status:")) {
                        itemLifeCycleState = item.substring(7);
                    }
                    if (itemValue != null || !item.startsWith("value:")) continue;
                    itemValue = item.substring(6);
                }
            }
            if (itemLifeCycleState == null || itemValue == null || !itemLifeCycleState.equalsIgnoreCase(currentState) || !itemValue.equalsIgnoreCase("false")) continue;
            allItemsAreChecked = false;
            break;
        }
        String actionPermissions = (stateIndex = this.states.indexOf(currentState)) >= this.distributedActionPermissions.size() - 1 ? this.distributedActionPermissions.get(0) : this.distributedActionPermissions.get(stateIndex);
        String promotePermissions = "#";
        String demotePermissions = "#";
        String[] userRoles = null;
        String user = CurrentSession.getUser();
        if (user != null && !actionPermissions.equals("#")) {
            String[] actionPermissionArray = actionPermissions.split(":");
            promotePermissions = actionPermissionArray[0];
            demotePermissions = actionPermissionArray[1];
            try {
                userRoles = CurrentSession.getUserRealm().getUserStoreManager().getRoleListOfUser(user);
            }
            catch (UserStoreException e) {
                // empty catch block
            }
        }
        if (stateIndex > -1 && stateIndex < this.states.size() - 1 && allItemsAreChecked) {
            if (promotePermissions.equals("#")) {
                actions.add(PROMOTE);
            } else if (context.getRegistry().getRegistryContext() != null) {
                roles = promotePermissions.split(",");
                boolean breakOuter = false;
                block9: for (String role : roles) {
                    if (breakOuter) break;
                    roleName = role.trim();
                    for (String userRole : userRoles) {
                        if (!roleName.equals(userRole)) continue;
                        actions.add(PROMOTE);
                        breakOuter = true;
                        continue block9;
                    }
                }
            }
        }
        if (stateIndex > 0) {
            if (demotePermissions.equals("#")) {
                actions.add(DEMOTE);
            } else if (context.getRegistry().getRegistryContext() != null) {
                roles = demotePermissions.split(",");
                boolean breakOuter = false;
                block11: for (String role : roles) {
                    if (breakOuter) break;
                    roleName = role.trim();
                    for (String userRole : userRoles) {
                        if (!roleName.equals(userRole)) continue;
                        actions.add(DEMOTE);
                        breakOuter = true;
                        continue block11;
                    }
                }
            }
        }
        return actions.toArray(new String[actions.size()]);
    }

    public void invoke(RequestContext requestContext, String action) throws RegistryException {
        String executableCommand;
        String newState;
        String FILE_SEPERATOR = "/";
        Resource resource = requestContext.getResource();
        String currentState = resource.getProperty(this.stateProperty);
        String resourcePath = requestContext.getResourcePath().getPath();
        String newresourcePath = "";
        String newRoles = "";
        String path = resource.getPath();
        String resourceName = path.substring(path.lastIndexOf("/") + 1);
        String nextLocation = "";
        int stateIndex = this.states.indexOf(currentState);
        if (stateIndex == -1) {
            throw new RegistryException("State '" + currentState + "' is not valid!");
        }
        if (PROMOTE.equals(action)) {
            if (stateIndex == this.states.size() - 1) {
                throw new RegistryException("Can't promote beyond end of configured lifecycle!");
            }
            List<Condition> conditions = this.transitions.get(currentState);
            if (conditions != null) {
                for (Condition condition : conditions) {
                    if (condition.isTrue(resource)) continue;
                    throw new RegistryException("Condition failed - " + condition.getDescription());
                }
            }
            nextLocation = stateIndex >= this.distributedLocations.size() - 1 ? this.distributedLocations.get(0) : this.distributedLocations.get(stateIndex + 1);
            newRoles = stateIndex >= this.distributedRoles.size() - 1 ? this.distributedRoles.get(0) : this.distributedRoles.get(stateIndex + 1);
            if (!nextLocation.equals("#")) {
                newresourcePath = nextLocation + resourceName;
            }
            newState = this.states.get(stateIndex + 1);
        } else if (DEMOTE.equals(action)) {
            if (stateIndex == 0) {
                throw new RegistryException("Can't demote beyond start of configured lifecycle!");
            }
            nextLocation = stateIndex <= 0 ? this.distributedLocations.get(0) : this.distributedLocations.get(stateIndex - 1);
            newRoles = stateIndex >= this.distributedRoles.size() - 1 ? this.distributedRoles.get(0) : this.distributedRoles.get(stateIndex + 1);
            if (!nextLocation.equals("#")) {
                newresourcePath = nextLocation + resourceName;
            }
            newState = this.states.get(stateIndex - 1);
        } else {
            if (ITEM_CLICK.equals(action)) {
                return;
            }
            throw new RegistryException("Invalid action '" + action + "'");
        }
        resource.setProperty(this.stateProperty, newState);
        requestContext.getRegistry().put(resourcePath, resource);
        if (!nextLocation.equals("#")) {
            try {
                requestContext.getRegistry().move(resourcePath, newresourcePath);
                if (!newRoles.equals("#") && requestContext.getRegistry().getRegistryContext() != null) {
                    try {
                        String[] roles;
                        AuthorizationManager authManager = CurrentSession.getUserRealm().getAuthorizationManager();
                        authManager.clearResourceAuthorizations(newresourcePath);
                        for (String role : roles = newRoles.split(",")) {
                            String roleName = role.trim();
                            authManager.authorizeRole(roleName, newresourcePath, "http://www.wso2.org/projects/registry/actions/get");
                            authManager.authorizeRole(roleName, newresourcePath, "http://www.wso2.org/projects/registry/actions/add");
                            authManager.authorizeRole(roleName, newresourcePath, "http://www.wso2.org/projects/registry/actions/delete");
                        }
                    }
                    catch (UserStoreException e) {
                        throw new RegistryException("Unable to setup roles for resource.", (Throwable)e);
                    }
                }
                requestContext.setResourcePath(new ResourcePath(newresourcePath));
            }
            catch (RegistryException e) {
                String msg = "Failed to move resource" + resourcePath + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
        }
        Properties properties = resource.getProperties();
        String lifecycleScript = "";
        String lifecycleScriptCommand = "";
        for (Object key : properties.keySet()) {
            List propValues;
            Object obj;
            if (!(key instanceof String)) continue;
            String propName = (String)key;
            String prefix = "registry.custom_lifecycle.";
            String suffix = "js.script.server." + currentState + "." + action;
            if (!propName.startsWith(prefix) || !propName.endsWith(suffix) || (obj = properties.get(key)) == null || !(obj instanceof List) || (propValues = (List)obj).size() != 2) continue;
            if (((String)propValues.get(0)).contains("function ")) {
                lifecycleScript = (String)propValues.get(0);
                lifecycleScriptCommand = (String)propValues.get(1) + "()";
                break;
            }
            lifecycleScript = (String)propValues.get(1);
            lifecycleScriptCommand = (String)propValues.get(0) + "()";
            break;
        }
        if ((executableCommand = lifecycleScript + "\n" + lifecycleScriptCommand).equals("\n")) {
            return;
        }
        this.executeJS(executableCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJS(String script) {
        Context cx = Context.enter();
        try {
            ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
            cx.putThreadLocal((Object)"axisConfigurationContext", (Object)configurationContext);
            AxisService service = new AxisService();
            service.addParameter("mashupAuthor", (Object)CurrentSession.getUser());
            cx.putThreadLocal((Object)"axisService", (Object)service);
            ScriptableObject scope = cx.initStandardObjects();
            ScriptableObject.defineClass((Scriptable)scope, ResourceHostObject.class);
            ScriptableObject.defineClass((Scriptable)scope, CollectionHostObject.class);
            ScriptableObject.defineClass((Scriptable)scope, RegistryHostObject.class);
            Object result = cx.evaluateString((Scriptable)scope, script, "<cmd>", 1, null);
            if (result != null && log.isInfoEnabled()) {
                log.info((Object)("JavaScript Result: " + Context.toString((Object)result)));
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Unable to defining registry host objects.", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to instantiate the given registry host object.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"An exception occurred while creating registry host objects.", (Throwable)e);
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to set user name parameter.", (Throwable)e);
        }
        catch (SecurityException securityException) {
        }
        finally {
            Context.exit();
        }
    }

    public String getCurrentState(Resource resource) {
        return resource.getProperty(this.stateProperty);
    }

    public void dissociate(RequestContext requestContext) {
        Resource resource = requestContext.getResource();
        if (resource != null) {
            resource.removeProperty(this.stateProperty);
            resource.removeProperty(this.lifecycleProperty);
        }
    }

    public boolean isValidRegistryCollection(String path) {
        if (!path.startsWith("/")) {
            return false;
        }
        return !path.contains("~!@#$%^*()+={}[]|\\<>");
    }

    class Condition {
        public String property;
        public ConditionEnum condition;
        public String value;

        Condition(String property, String condition, String value) {
            this.property = property;
            this.condition = ConditionEnum.valueOf(condition);
            this.value = value;
        }

        public boolean isTrue(Resource resource) {
            String propVal = resource.getProperty(this.property);
            if (propVal == null) {
                return this.condition == ConditionEnum.isNull;
            }
            switch (this.condition) {
                case equals: {
                    return propVal.equals(this.value);
                }
                case contains: {
                    return propVal.indexOf(this.value) > -1;
                }
                case lessThan: {
                    return Integer.parseInt(propVal) < Integer.parseInt(this.value);
                }
                case greaterThan: {
                    return Integer.parseInt(propVal) > Integer.parseInt(this.value);
                }
            }
            return false;
        }

        public String getDescription() {
            StringBuffer ret = new StringBuffer();
            ret.append("Property '");
            ret.append(this.property);
            ret.append("' ");
            switch (this.condition) {
                case isNull: {
                    ret.append("must be null");
                    break;
                }
                case equals: {
                    ret.append("must equal '");
                    ret.append(this.value);
                    ret.append("'");
                    break;
                }
                case contains: {
                    ret.append("must contain '");
                    ret.append(this.value);
                    ret.append("'");
                    break;
                }
                case lessThan: {
                    ret.append("must be less than ");
                    ret.append(this.value);
                    break;
                }
                case greaterThan: {
                    ret.append("must be greater than ");
                    ret.append(this.value);
                }
            }
            return ret.toString();
        }
    }

    public static enum ConditionEnum {
        isNull,
        equals,
        contains,
        lessThan,
        greaterThan;

    }
}

