/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.handler.services;

import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.admin.api.handler.IHandlerManagementService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.handler.beans.HandlerConfigurationBean;
import org.wso2.carbon.registry.handler.beans.SimulationRequest;
import org.wso2.carbon.registry.handler.beans.SimulationResponse;
import org.wso2.carbon.registry.handler.util.CommonUtil;

public class HandlerManagementService
extends RegistryAbstractAdmin
implements IHandlerManagementService<SimulationResponse, SimulationRequest> {
    private static final Log log = LogFactory.getLog(HandlerManagementService.class);

    public String getHandlerCollectionLocation() throws Exception {
        return CommonUtil.getContextRoot();
    }

    public void setHandlerCollectionLocation(String location) throws Exception {
        CommonUtil.setContextRoot(location);
    }

    public String[] getHandlerList() throws Exception {
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        return CommonUtil.getHandlerList(configSystemRegistry);
    }

    public String getHandlerConfiguration(String name) throws Exception {
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        return CommonUtil.getHandlerConfiguration(configSystemRegistry, name);
    }

    public boolean deleteHandler(String name) throws Exception {
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        return !RegistryUtils.isRegistryReadOnly((RegistryContext)configSystemRegistry.getRegistryContext()) && CommonUtil.deleteHandler(configSystemRegistry, name);
    }

    private String parseHandlerConfiguration(String payload) throws XMLStreamException {
        OMElement configurationElement = AXIOMUtil.stringToOM((String)payload);
        HandlerConfigurationBean handlerConfigurationBean = CommonUtil.deserializeHandlerConfiguration(configurationElement);
        if (handlerConfigurationBean == null || handlerConfigurationBean.getHandlerClass() == null || handlerConfigurationBean.getFilter() == null || handlerConfigurationBean.getFilter().getFilterClass() == null) {
            return null;
        }
        return CommonUtil.serializeHandlerConfiguration(handlerConfigurationBean).toString();
    }

    public boolean createHandler(String payload) throws Exception {
        String parsedPayload;
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        try {
            parsedPayload = this.parseHandlerConfiguration(payload);
        }
        catch (Exception e) {
            log.error((Object)"Unable to parse the given handler configuration.", (Throwable)e);
            throw new Exception("Unable to parse the given handler configuration. " + e.getMessage());
        }
        if (parsedPayload == null) {
            throw new Exception("The provided handler configuration is invalid.");
        }
        return !RegistryUtils.isRegistryReadOnly((RegistryContext)configSystemRegistry.getRegistryContext()) && CommonUtil.addHandler(configSystemRegistry, parsedPayload);
    }

    public boolean updateHandler(String oldName, String payload) throws Exception {
        String parsedPayload;
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        try {
            parsedPayload = this.parseHandlerConfiguration(payload);
        }
        catch (Exception e) {
            log.error((Object)"Unable to parse the given handler configuration.", (Throwable)e);
            throw new Exception("Unable to parse the given handler configuration. " + e.getMessage());
        }
        if (parsedPayload == null) {
            throw new Exception("The provided handler configuration is invalid.");
        }
        return !RegistryUtils.isRegistryReadOnly((RegistryContext)configSystemRegistry.getRegistryContext()) && CommonUtil.updateHandler(configSystemRegistry, oldName, parsedPayload);
    }

    public SimulationResponse simulate(SimulationRequest request) throws Exception {
        Registry rootRegistry = this.getRootRegistry();
        CommonUtil.simulateRegistryOperation(rootRegistry, request);
        return CommonUtil.getSimulationResponse();
    }
}

