/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks4Message;
import socks.Socks5Message;
import socks.SocksException;
import socks.SocksServerSocket;
import socks.SocksSocket;
import socks.UDPRelayServer;
import socks.server.ServerAuthenticator;

public class ProxyServer
implements Runnable {
    ServerAuthenticator auth;
    ProxyMessage msg = null;
    Socket sock = null;
    Socket remote_sock = null;
    ServerSocket ss = null;
    UDPRelayServer relayServer = null;
    InputStream in;
    InputStream remote_in;
    OutputStream out;
    OutputStream remote_out;
    int mode;
    static final int START_MODE = 0;
    static final int ACCEPT_MODE = 1;
    static final int PIPE_MODE = 2;
    static final int ABORT_MODE = 3;
    static final int BUF_SIZE = 8192;
    Thread pipe_thread1;
    Thread pipe_thread2;
    long lastReadTime;
    static int iddleTimeout = 180000;
    static int acceptTimeout = 180000;
    static PrintStream log = null;
    static Proxy proxy;
    static final String[] command_names;

    static {
        command_names = new String[]{"CONNECT", "BIND", "UDP_ASSOCIATE"};
    }

    public ProxyServer(ServerAuthenticator serverAuthenticator) {
        this.auth = serverAuthenticator;
    }

    ProxyServer(ServerAuthenticator serverAuthenticator, Socket socket) {
        this.auth = serverAuthenticator;
        this.sock = socket;
        this.mode = 0;
    }

    private synchronized void abort() {
        if (this.mode == 3) {
            return;
        }
        this.mode = 3;
        try {
            ProxyServer.log("Aborting operation");
            if (this.remote_sock != null) {
                this.remote_sock.close();
            }
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.relayServer != null) {
                this.relayServer.stop();
            }
            if (this.ss != null) {
                this.ss.close();
            }
            if (this.pipe_thread1 != null) {
                this.pipe_thread1.interrupt();
            }
            if (this.pipe_thread2 != null) {
                this.pipe_thread2.interrupt();
            }
        }
        catch (IOException iOException) {}
    }

    static final String command2String(int n) {
        if (n > 0 && n < 4) {
            return command_names[n - 1];
        }
        return "Unknown Command " + n;
    }

    private void doAccept() throws IOException {
        Socket socket;
        long l = System.currentTimeMillis();
        while (true) {
            if ((socket = this.ss.accept()).getInetAddress().equals(this.msg.ip)) break;
            if (this.ss instanceof SocksServerSocket) {
                socket.close();
                this.ss.close();
                throw new SocksException(1);
            }
            if (acceptTimeout != 0) {
                int n = acceptTimeout - (int)(System.currentTimeMillis() - l);
                if (n <= 0) {
                    throw new InterruptedIOException("In doAccept()");
                }
                this.ss.setSoTimeout(n);
            }
            socket.close();
        }
        this.ss.close();
        this.remote_sock = socket;
        this.remote_in = socket.getInputStream();
        this.remote_out = socket.getOutputStream();
        this.remote_sock.setSoTimeout(iddleTimeout);
        ProxyServer.log("Accepted from " + socket.getInetAddress() + ":" + socket.getPort());
        ProxyMessage proxyMessage = this.msg.version == 5 ? new Socks5Message(0, socket.getInetAddress(), socket.getPort()) : new Socks4Message(90, socket.getInetAddress(), socket.getPort());
        proxyMessage.write(this.out);
    }

    public static Proxy getProxy() {
        return proxy;
    }

    private void handleException(IOException iOException) {
        if (this.msg == null) {
            return;
        }
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 2) {
            return;
        }
        int n = 1;
        if (iOException instanceof SocksException) {
            n = ((SocksException)iOException).errCode;
        } else if (iOException instanceof NoRouteToHostException) {
            n = 4;
        } else if (iOException instanceof ConnectException) {
            n = 5;
        } else if (iOException instanceof InterruptedIOException) {
            n = 6;
        }
        if (n > 8 || n < 0) {
            n = 1;
        }
        this.sendErrorMessage(n);
    }

    private void handleRequest(ProxyMessage proxyMessage) throws IOException {
        if (!this.auth.checkRequest(proxyMessage)) {
            throw new SocksException(1);
        }
        if (proxyMessage.ip == null) {
            if (proxyMessage instanceof Socks5Message) {
                proxyMessage.ip = InetAddress.getByName(proxyMessage.host);
            } else {
                throw new SocksException(1);
            }
        }
        ProxyServer.log(proxyMessage);
        switch (proxyMessage.command) {
            case 1: {
                this.onConnect(proxyMessage);
                break;
            }
            case 2: {
                this.onBind(proxyMessage);
                break;
            }
            case 3: {
                this.onUDP(proxyMessage);
                break;
            }
            default: {
                throw new SocksException(7);
            }
        }
    }

    static final void log(String string) {
        if (log != null) {
            log.println(string);
            log.flush();
        }
    }

    static final void log(ProxyMessage proxyMessage) {
        ProxyServer.log("Request version:" + proxyMessage.version + "\tCommand: " + ProxyServer.command2String(proxyMessage.command));
        ProxyServer.log("IP:" + proxyMessage.ip + "\tPort:" + proxyMessage.port + (proxyMessage.version == 4 ? "\tUser:" + proxyMessage.user : ""));
    }

    private void onBind(ProxyMessage proxyMessage) throws IOException {
        int n;
        block6: {
            ProxyMessage proxyMessage2 = null;
            this.ss = proxy == null ? new ServerSocket(0) : new SocksServerSocket(proxy, proxyMessage.ip, proxyMessage.port);
            this.ss.setSoTimeout(acceptTimeout);
            ProxyServer.log("Trying accept on " + this.ss.getInetAddress() + ":" + this.ss.getLocalPort());
            proxyMessage2 = proxyMessage.version == 5 ? new Socks5Message(0, this.ss.getInetAddress(), this.ss.getLocalPort()) : new Socks4Message(90, this.ss.getInetAddress(), this.ss.getLocalPort());
            proxyMessage2.write(this.out);
            this.mode = 1;
            this.pipe_thread1 = Thread.currentThread();
            this.pipe_thread2 = new Thread(this);
            this.pipe_thread2.start();
            this.sock.setSoTimeout(0);
            n = 0;
            try {
                while ((n = this.in.read()) >= 0) {
                    if (this.mode == 1) continue;
                    if (this.mode != 2) {
                        return;
                    }
                    this.remote_out.write(n);
                    break;
                }
            }
            catch (EOFException eOFException) {
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.mode == 2) break block6;
                return;
            }
        }
        if (n < 0) {
            return;
        }
        this.pipe(this.in, this.remote_out);
    }

    private void onConnect(ProxyMessage proxyMessage) throws IOException {
        ProxyMessage proxyMessage2 = null;
        Socket socket = proxy == null ? new Socket(proxyMessage.ip, proxyMessage.port) : new SocksSocket(proxy, proxyMessage.ip, proxyMessage.port);
        ProxyServer.log("Connected to " + socket.getInetAddress() + ":" + socket.getPort());
        proxyMessage2 = proxyMessage instanceof Socks5Message ? new Socks5Message(0, socket.getLocalAddress(), socket.getLocalPort()) : new Socks4Message(90, socket.getLocalAddress(), socket.getLocalPort());
        proxyMessage2.write(this.out);
        this.startPipe(socket);
    }

    private void onUDP(ProxyMessage proxyMessage) throws IOException {
        if (proxyMessage.ip.getHostAddress().equals("0.0.0.0")) {
            proxyMessage.ip = this.sock.getInetAddress();
        }
        ProxyServer.log("Creating UDP relay server for " + proxyMessage.ip + ":" + proxyMessage.port);
        this.relayServer = new UDPRelayServer(proxyMessage.ip, proxyMessage.port, Thread.currentThread(), this.sock, this.auth);
        Socks5Message socks5Message = new Socks5Message(0, this.relayServer.relayIP, this.relayServer.relayPort);
        ((ProxyMessage)socks5Message).write(this.out);
        this.relayServer.start();
        this.sock.setSoTimeout(0);
        try {
            while (this.in.read() >= 0) {
            }
        }
        catch (EOFException eOFException) {}
    }

    private void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.lastReadTime = System.currentTimeMillis();
        byte[] byArray = new byte[8192];
        int n = 0;
        while (n >= 0) {
            try {
                if (n != 0) {
                    outputStream.write(byArray, 0, n);
                    outputStream.flush();
                }
                n = inputStream.read(byArray);
                this.lastReadTime = System.currentTimeMillis();
            }
            catch (InterruptedIOException interruptedIOException) {
                if (iddleTimeout == 0) {
                    return;
                }
                long l = System.currentTimeMillis() - this.lastReadTime;
                if (l >= (long)(iddleTimeout - 1000)) {
                    return;
                }
                n = 0;
            }
        }
    }

    private ProxyMessage readMsg(InputStream inputStream) throws IOException {
        ProxyMessage proxyMessage;
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        pushbackInputStream.unread(n);
        if (n == 5) {
            proxyMessage = new Socks5Message(pushbackInputStream, false);
        } else if (n == 4) {
            proxyMessage = new Socks4Message(pushbackInputStream, false);
        } else {
            throw new SocksException(1);
        }
        return proxyMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        switch (this.mode) {
            case 0: {
                try {
                    try {
                        this.startSession();
                    }
                    catch (IOException iOException) {
                        this.handleException(iOException);
                    }
                    Object var2_3 = null;
                    this.abort();
                    if (this.auth != null) {
                        this.auth.endSession();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    this.abort();
                    if (this.auth != null) {
                        this.auth.endSession();
                    }
                    ProxyServer.log("Main thread(client->remote)stopped.");
                    throw throwable;
                }
                ProxyServer.log("Main thread(client->remote)stopped.");
                return;
            }
            case 1: {
                try {
                    try {
                        this.doAccept();
                        this.mode = 2;
                        this.pipe_thread1.interrupt();
                        this.pipe(this.remote_in, this.out);
                    }
                    catch (IOException iOException) {
                        this.handleException(iOException);
                    }
                    Object var2_5 = null;
                    this.abort();
                }
                catch (Throwable throwable) {
                    Object var2_6 = null;
                    this.abort();
                    ProxyServer.log("Accept thread(remote->client) stopped");
                    throw throwable;
                }
                ProxyServer.log("Accept thread(remote->client) stopped");
                return;
            }
            case 2: {
                try {
                    try {
                        this.pipe(this.remote_in, this.out);
                    }
                    catch (IOException iOException) {
                    }
                    Object var2_7 = null;
                    this.abort();
                }
                catch (Throwable throwable) {
                    Object var2_8 = null;
                    this.abort();
                    ProxyServer.log("Support thread(remote->client) stopped");
                    throw throwable;
                }
                ProxyServer.log("Support thread(remote->client) stopped");
                return;
            }
            default: {
                ProxyServer.log("Unexpected MODE " + this.mode);
                return;
            }
            case 3: 
        }
    }

    private void sendErrorMessage(int n) {
        ProxyMessage proxyMessage = this.msg instanceof Socks4Message ? new Socks4Message(91) : new Socks5Message(n);
        try {
            proxyMessage.write(this.out);
        }
        catch (IOException iOException) {}
    }

    public static void setAcceptTimeout(int n) {
        acceptTimeout = n;
    }

    public static void setDatagramSize(int n) {
        UDPRelayServer.setDatagramSize(n);
    }

    public static void setIddleTimeout(int n) {
        iddleTimeout = n;
    }

    public static void setLog(OutputStream outputStream) {
        log = outputStream == null ? null : new PrintStream(outputStream, true);
        UDPRelayServer.log = log;
    }

    public static void setProxy(Proxy proxy) {
        UDPRelayServer.proxy = ProxyServer.proxy = proxy;
    }

    public static void setUDPTimeout(int n) {
        UDPRelayServer.setTimeout(n);
    }

    public void start(int n) {
        this.start(n, 5, null);
    }

    public void start(int n, int n2, InetAddress inetAddress) {
        try {
            this.ss = new ServerSocket(n, n2, inetAddress);
            ProxyServer.log("Starting SOCKS Proxy on:" + this.ss.getInetAddress().getHostAddress() + ":" + this.ss.getLocalPort());
            while (true) {
                Socket socket = this.ss.accept();
                ProxyServer.log("Accepted from:" + socket.getInetAddress().getHostName() + ":" + socket.getPort());
                ProxyServer proxyServer = new ProxyServer(this.auth, socket);
                new Thread(proxyServer).start();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void startPipe(Socket socket) {
        this.mode = 2;
        this.remote_sock = socket;
        try {
            this.remote_in = socket.getInputStream();
            this.remote_out = socket.getOutputStream();
            this.pipe_thread1 = Thread.currentThread();
            this.pipe_thread2 = new Thread(this);
            this.pipe_thread2.start();
            this.pipe(this.in, this.remote_out);
        }
        catch (IOException iOException) {}
    }

    private void startSession() throws IOException {
        this.sock.setSoTimeout(iddleTimeout);
        try {
            this.auth = this.auth.startSession(this.sock);
        }
        catch (IOException iOException) {
            ProxyServer.log("Auth throwed exception:" + iOException);
            this.auth = null;
            return;
        }
        if (this.auth == null) {
            ProxyServer.log("Authentication failed");
            return;
        }
        this.in = this.auth.getInputStream();
        this.out = this.auth.getOutputStream();
        this.msg = this.readMsg(this.in);
        this.handleRequest(this.msg);
    }

    public void stop() {
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {}
    }
}

