/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import socks.InetRange;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks4Message;
import socks.SocksException;

public class Socks4Proxy
extends Proxy
implements Cloneable {
    String user;

    public Socks4Proxy(String string, int n, String string2) throws UnknownHostException {
        this(null, string, n, string2);
    }

    public Socks4Proxy(InetAddress inetAddress, int n, String string) {
        this(null, inetAddress, n, string);
    }

    public Socks4Proxy(Proxy proxy, String string, int n, String string2) throws UnknownHostException {
        super(proxy, string, n);
        this.user = new String(string2);
        this.version = 4;
    }

    public Socks4Proxy(Proxy proxy, InetAddress inetAddress, int n, String string) {
        super(proxy, inetAddress, n);
        this.user = new String(string);
        this.version = 4;
    }

    public Object clone() {
        Socks4Proxy socks4Proxy = new Socks4Proxy(this.proxyIP, this.proxyPort, this.user);
        socks4Proxy.directHosts = (InetRange)this.directHosts.clone();
        socks4Proxy.chainProxy = this.chainProxy;
        return socks4Proxy;
    }

    protected Proxy copy() {
        Socks4Proxy socks4Proxy = new Socks4Proxy(this.proxyIP, this.proxyPort, this.user);
        socks4Proxy.directHosts = this.directHosts;
        socks4Proxy.chainProxy = this.chainProxy;
        return socks4Proxy;
    }

    protected ProxyMessage formMessage(int n, String string, int n2) throws UnknownHostException {
        return this.formMessage(n, InetAddress.getByName(string), n2);
    }

    protected ProxyMessage formMessage(int n, InetAddress inetAddress, int n2) {
        switch (n) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                return null;
            }
        }
        return new Socks4Message(n, inetAddress, n2, this.user);
    }

    protected ProxyMessage formMessage(InputStream inputStream) throws SocksException, IOException {
        return new Socks4Message(inputStream, true);
    }
}

