/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks5Message;
import socks.Socks5Proxy;
import socks.SocksException;
import socks.UDPEncapsulation;

public class Socks5DatagramSocket
extends DatagramSocket {
    InetAddress relayIP;
    int relayPort;
    Socks5Proxy proxy;
    private boolean server_mode = false;
    UDPEncapsulation encapsulation;

    public Socks5DatagramSocket() throws SocksException, IOException {
        this(Proxy.defaultProxy, 0, null);
    }

    public Socks5DatagramSocket(int n) throws SocksException, IOException {
        this(Proxy.defaultProxy, n, null);
    }

    public Socks5DatagramSocket(int n, InetAddress inetAddress) throws SocksException, IOException {
        this(Proxy.defaultProxy, n, inetAddress);
    }

    public Socks5DatagramSocket(Proxy proxy, int n, InetAddress inetAddress) throws SocksException, IOException {
        super(n, inetAddress);
        if (proxy == null) {
            throw new SocksException(65536);
        }
        if (!(proxy instanceof Socks5Proxy)) {
            throw new SocksException(-1, "Datagram Socket needs Proxy version 5");
        }
        if (proxy.chainProxy != null) {
            throw new SocksException(393216, "Datagram Sockets do not support proxy chaining.");
        }
        this.proxy = (Socks5Proxy)proxy.copy();
        ProxyMessage proxyMessage = this.proxy.udpAssociate(super.getLocalAddress(), super.getLocalPort());
        this.relayIP = proxyMessage.ip;
        if (this.relayIP.getHostAddress().equals("0.0.0.0")) {
            this.relayIP = this.proxy.proxyIP;
        }
        this.relayPort = proxyMessage.port;
        this.encapsulation = this.proxy.udp_encapsulation;
    }

    Socks5DatagramSocket(boolean bl, UDPEncapsulation uDPEncapsulation, InetAddress inetAddress, int n) throws IOException {
        this.server_mode = bl;
        this.relayIP = inetAddress;
        this.relayPort = n;
        this.encapsulation = uDPEncapsulation;
        this.proxy = null;
    }

    public void close() {
        if (!this.server_mode) {
            this.proxy.endSession();
        }
        super.close();
    }

    private byte[] formHeader(String string, int n) {
        Socks5Message socks5Message = new Socks5Message(0, string, n);
        socks5Message.data[0] = 0;
        return socks5Message.data;
    }

    private byte[] formHeader(InetAddress inetAddress, int n) {
        Socks5Message socks5Message = new Socks5Message(0, inetAddress, n);
        socks5Message.data[0] = 0;
        return socks5Message.data;
    }

    public InetAddress getLocalAddress() {
        if (this.server_mode) {
            return super.getLocalAddress();
        }
        return this.relayIP;
    }

    public int getLocalPort() {
        if (this.server_mode) {
            return super.getLocalPort();
        }
        return this.relayPort;
    }

    public boolean isProxyAlive(int n) {
        if (this.server_mode) {
            return false;
        }
        if (this.proxy != null) {
            try {
                this.proxy.proxySocket.setSoTimeout(n);
                int n2 = this.proxy.in.read();
                return n2 >= 0;
            }
            catch (InterruptedIOException interruptedIOException) {
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public void receive(DatagramPacket datagramPacket) throws IOException {
        int n;
        int n2;
        super.receive(datagramPacket);
        if (this.server_mode) {
            int n3 = datagramPacket.getLength();
            n2 = this.getSoTimeout();
            long l = System.currentTimeMillis();
            while (!this.relayIP.equals(datagramPacket.getAddress()) || this.relayPort != datagramPacket.getPort()) {
                datagramPacket.setLength(n3);
                if (n2 != 0) {
                    n = n2 - (int)(System.currentTimeMillis() - l);
                    if (n <= 0) {
                        throw new InterruptedIOException("In Socks5DatagramSocket->receive()");
                    }
                    this.setSoTimeout(n);
                }
                super.receive(datagramPacket);
            }
            if (n2 != 0) {
                this.setSoTimeout(n2);
            }
        } else if (!this.relayIP.equals(datagramPacket.getAddress()) || this.relayPort != datagramPacket.getPort()) {
            return;
        }
        byte[] byArray = datagramPacket.getData();
        if (this.encapsulation != null) {
            byArray = this.encapsulation.udpEncapsulate(byArray, false);
        }
        n2 = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, datagramPacket.getLength());
        Socks5Message socks5Message = new Socks5Message(byteArrayInputStream);
        datagramPacket.setPort(socks5Message.port);
        datagramPacket.setAddress(((ProxyMessage)socks5Message).getInetAddress());
        n = byteArrayInputStream.available();
        System.arraycopy(byArray, n2 + datagramPacket.getLength() - n, byArray, n2, n);
        datagramPacket.setLength(n);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        if (!this.server_mode && this.proxy.isDirect(datagramPacket.getAddress())) {
            super.send(datagramPacket);
            return;
        }
        byte[] byArray = this.formHeader(datagramPacket.getAddress(), datagramPacket.getPort());
        byte[] byArray2 = new byte[byArray.length + datagramPacket.getLength()];
        byte[] byArray3 = datagramPacket.getData();
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(byArray3, 0, byArray2, byArray.length, datagramPacket.getLength());
        if (this.encapsulation != null) {
            byArray2 = this.encapsulation.udpEncapsulate(byArray2, true);
        }
        super.send(new DatagramPacket(byArray2, byArray2.length, this.relayIP, this.relayPort));
    }

    public void send(DatagramPacket datagramPacket, String string) throws IOException {
        if (this.proxy.isDirect(string)) {
            datagramPacket.setAddress(InetAddress.getByName(string));
            super.send(datagramPacket);
            return;
        }
        if (this.proxy.resolveAddrLocally) {
            datagramPacket.setAddress(InetAddress.getByName(string));
        }
        byte[] byArray = this.formHeader(string, datagramPacket.getPort());
        byte[] byArray2 = new byte[byArray.length + datagramPacket.getLength()];
        byte[] byArray3 = datagramPacket.getData();
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(byArray3, 0, byArray2, byArray.length, datagramPacket.getLength());
        if (this.encapsulation != null) {
            byArray2 = this.encapsulation.udpEncapsulate(byArray2, true);
        }
        super.send(new DatagramPacket(byArray2, byArray2.length, this.relayIP, this.relayPort));
    }
}

