/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import socks.ProxyMessage;
import socks.SocksException;

class Socks5Message
extends ProxyMessage {
    public int addrType;
    byte[] data;
    public static final int SOCKS_VERSION = 5;
    public static final int SOCKS_ATYP_IPV4 = 1;
    public static final int SOCKS_ATYP_DOMAINNAME = 3;
    public static final int SOCKS_ATYP_IPV6 = 4;
    public static final int SOCKS_IPV6_LENGTH = 16;
    static boolean doResolveIP = true;

    public Socks5Message(int n) {
        super(n, null, 0);
        this.data = new byte[3];
        this.data[0] = 5;
        this.data[1] = (byte)n;
        this.data[2] = 0;
    }

    public Socks5Message(int n, String string, int n2) {
        super(n, null, n2);
        this.host = string;
        this.version = 5;
        this.addrType = 3;
        byte[] byArray = string.getBytes();
        this.data = new byte[7 + byArray.length];
        this.data[0] = 5;
        this.data[1] = (byte)this.command;
        this.data[2] = 0;
        this.data[3] = 3;
        this.data[4] = (byte)byArray.length;
        System.arraycopy(byArray, 0, this.data, 5, byArray.length);
        this.data[this.data.length - 2] = (byte)(n2 >> 8);
        this.data[this.data.length - 1] = (byte)n2;
    }

    public Socks5Message(int n, InetAddress inetAddress, int n2) {
        super(n, inetAddress, n2);
        byte[] byArray;
        this.host = inetAddress == null ? "0.0.0.0" : inetAddress.getHostName();
        this.version = 5;
        if (inetAddress == null) {
            byArray = new byte[4];
            byArray[3] = 0;
            byArray[2] = 0;
            byArray[1] = 0;
            byArray[0] = 0;
        } else {
            byArray = inetAddress.getAddress();
        }
        this.addrType = byArray.length == 4 ? 1 : 4;
        this.data = new byte[6 + byArray.length];
        this.data[0] = 5;
        this.data[1] = (byte)this.command;
        this.data[2] = 0;
        this.data[3] = (byte)this.addrType;
        System.arraycopy(byArray, 0, this.data, 4, byArray.length);
        this.data[this.data.length - 2] = (byte)(n2 >> 8);
        this.data[this.data.length - 1] = (byte)n2;
    }

    public Socks5Message(InputStream inputStream) throws SocksException, IOException {
        this(inputStream, true);
    }

    public Socks5Message(InputStream inputStream, boolean bl) throws SocksException, IOException {
        this.read(inputStream, bl);
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.ip != null) {
            return this.ip;
        }
        this.ip = InetAddress.getByName(this.host);
        return this.ip;
    }

    public void read(InputStream inputStream) throws SocksException, IOException {
        this.read(inputStream, true);
    }

    public void read(InputStream inputStream, boolean bl) throws SocksException, IOException {
        block8: {
            this.data = null;
            this.ip = null;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.version = dataInputStream.readUnsignedByte();
            this.command = dataInputStream.readUnsignedByte();
            if (bl && this.command != 0) {
                throw new SocksException(this.command);
            }
            int n = dataInputStream.readUnsignedByte();
            this.addrType = dataInputStream.readUnsignedByte();
            switch (this.addrType) {
                case 1: {
                    byte[] byArray = new byte[4];
                    dataInputStream.readFully(byArray);
                    this.host = ProxyMessage.bytes2IPV4(byArray, 0);
                    break;
                }
                case 4: {
                    byte[] byArray = new byte[16];
                    dataInputStream.readFully(byArray);
                    this.host = ProxyMessage.bytes2IPV6(byArray, 0);
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[dataInputStream.readUnsignedByte()];
                    dataInputStream.readFully(byArray);
                    this.host = new String(byArray);
                    break;
                }
                default: {
                    throw new SocksException(393216);
                }
            }
            this.port = dataInputStream.readUnsignedShort();
            if (this.addrType == 3 || !doResolveIP) break block8;
            try {
                this.ip = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public static boolean resolveIP() {
        return doResolveIP;
    }

    public static boolean resolveIP(boolean bl) {
        boolean bl2 = doResolveIP;
        doResolveIP = bl;
        return bl2;
    }

    public String toString() {
        String string = "Socks5Message:\nVN   " + this.version + "\n" + "CMD  " + this.command + "\n" + "ATYP " + this.addrType + "\n" + "ADDR " + this.host + "\n" + "PORT " + this.port + "\n";
        return string;
    }

    public void write(OutputStream outputStream) throws SocksException, IOException {
        if (this.data == null) {
            Socks5Message socks5Message;
            if (this.addrType == 3) {
                socks5Message = new Socks5Message(this.command, this.host, this.port);
            } else {
                if (this.ip == null) {
                    try {
                        this.ip = InetAddress.getByName(this.host);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new SocksException(393216);
                    }
                }
                socks5Message = new Socks5Message(this.command, this.ip, this.port);
            }
            this.data = socks5Message.data;
        }
        outputStream.write(this.data);
    }
}

