/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import socks.Authentication;
import socks.AuthenticationNone;
import socks.InetRange;
import socks.Proxy;
import socks.ProxyMessage;
import socks.Socks5Message;
import socks.SocksException;
import socks.UDPEncapsulation;

public class Socks5Proxy
extends Proxy
implements Cloneable {
    private Hashtable authMethods = new Hashtable();
    private int selectedMethod;
    boolean resolveAddrLocally = true;
    UDPEncapsulation udp_encapsulation = null;

    public Socks5Proxy(String string, int n) throws UnknownHostException {
        this(null, string, n);
    }

    public Socks5Proxy(InetAddress inetAddress, int n) {
        this(null, inetAddress, n);
    }

    public Socks5Proxy(Proxy proxy, String string, int n) throws UnknownHostException {
        super(proxy, string, n);
        this.version = 5;
        this.setAuthenticationMethod(0, new AuthenticationNone());
    }

    public Socks5Proxy(Proxy proxy, InetAddress inetAddress, int n) {
        super(proxy, inetAddress, n);
        this.version = 5;
        this.setAuthenticationMethod(0, new AuthenticationNone());
    }

    public Object clone() {
        Socks5Proxy socks5Proxy = new Socks5Proxy(this.proxyIP, this.proxyPort);
        socks5Proxy.authMethods = (Hashtable)this.authMethods.clone();
        socks5Proxy.directHosts = (InetRange)this.directHosts.clone();
        socks5Proxy.resolveAddrLocally = this.resolveAddrLocally;
        socks5Proxy.chainProxy = this.chainProxy;
        return socks5Proxy;
    }

    protected Proxy copy() {
        Socks5Proxy socks5Proxy = new Socks5Proxy(this.proxyIP, this.proxyPort);
        socks5Proxy.authMethods = this.authMethods;
        socks5Proxy.directHosts = this.directHosts;
        socks5Proxy.chainProxy = this.chainProxy;
        socks5Proxy.resolveAddrLocally = this.resolveAddrLocally;
        return socks5Proxy;
    }

    protected ProxyMessage formMessage(int n, String string, int n2) throws UnknownHostException {
        if (this.resolveAddrLocally) {
            return this.formMessage(n, InetAddress.getByName(string), n2);
        }
        return new Socks5Message(n, string, n2);
    }

    protected ProxyMessage formMessage(int n, InetAddress inetAddress, int n2) {
        return new Socks5Message(n, inetAddress, n2);
    }

    protected ProxyMessage formMessage(InputStream inputStream) throws SocksException, IOException {
        return new Socks5Message(inputStream);
    }

    public Authentication getAuthenticationMethod(int n) {
        Object v = this.authMethods.get(new Integer(n));
        if (v == null) {
            return null;
        }
        return (Authentication)v;
    }

    public boolean resolveAddrLocally() {
        return this.resolveAddrLocally;
    }

    public boolean resolveAddrLocally(boolean bl) {
        boolean bl2 = this.resolveAddrLocally;
        this.resolveAddrLocally = bl;
        return bl2;
    }

    public boolean setAuthenticationMethod(int n, Authentication authentication) {
        if (n < 0 || n > 255) {
            return false;
        }
        if (authentication == null) {
            return this.authMethods.remove(new Integer(n)) != null;
        }
        this.authMethods.put(new Integer(n), authentication);
        return true;
    }

    protected void startSession() throws SocksException {
        super.startSession();
        Socket socket = this.proxySocket;
        try {
            byte by = (byte)this.authMethods.size();
            byte[] byArray = new byte[2 + by];
            byArray[0] = (byte)this.version;
            byArray[1] = by;
            int n = 2;
            Enumeration enumeration = this.authMethods.keys();
            while (enumeration.hasMoreElements()) {
                byArray[n++] = (byte)((Integer)enumeration.nextElement()).intValue();
            }
            this.out.write(byArray);
            this.out.flush();
            int n2 = this.in.read();
            this.selectedMethod = this.in.read();
            if (n2 < 0 || this.selectedMethod < 0) {
                this.endSession();
                throw new SocksException(196608, "Connection to proxy lost.");
            }
            if (this.selectedMethod == 255) {
                socket.close();
                throw new SocksException(262144);
            }
            Authentication authentication = this.getAuthenticationMethod(this.selectedMethod);
            if (authentication == null) {
                throw new SocksException(393216, "Speciefied Authentication not found!");
            }
            Object[] objectArray = authentication.doSocksAuthentication(this.selectedMethod, socket);
            if (objectArray == null) {
                throw new SocksException(327680);
            }
            this.in = (InputStream)objectArray[0];
            this.out = (OutputStream)objectArray[1];
            if (objectArray.length > 2) {
                this.udp_encapsulation = (UDPEncapsulation)objectArray[2];
            }
        }
        catch (SocksException socksException) {
            throw socksException;
        }
        catch (UnknownHostException unknownHostException) {
            throw new SocksException(131072);
        }
        catch (SocketException socketException) {
            throw new SocksException(131072);
        }
        catch (IOException iOException) {
            throw new SocksException(196608, String.valueOf(String.valueOf(iOException)));
        }
    }
}

