/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.UnknownHostException;
import socks.InetRange;
import socks.Proxy;
import socks.Socks4Proxy;
import socks.Socks5Proxy;
import socks.UserPasswordAuthentication;

public class SocksDialog
extends Dialog
implements WindowListener,
ItemListener,
ActionListener,
Runnable {
    TextField host_text;
    TextField port_text;
    TextField user_text;
    TextField password_text;
    TextField direct_text;
    Button add_button;
    Button remove_button;
    Button cancel_button;
    Button ok_button;
    Button dismiss_button;
    List direct_list;
    Checkbox socks4radio;
    Checkbox socks5radio;
    Checkbox none_check;
    Checkbox up_check;
    Checkbox gssapi_check;
    Dialog warning_dialog;
    Label warning_label;
    String host;
    String user;
    String password;
    int port;
    Thread net_thread = null;
    CheckboxGroup socks_group = new CheckboxGroup();
    Proxy proxy;
    InetRange ir;
    static final int COMMAND_MODE = 0;
    static final int OK_MODE = 1;
    int mode;
    public static boolean useThreads = true;

    public SocksDialog(Frame frame) {
        this(frame, (Proxy)null);
    }

    public SocksDialog(Frame frame, Proxy proxy) {
        super(frame, "Proxy Configuration", true);
        this.warning_dialog = new Dialog(frame, "Warning", true);
        this.guiInit();
        this.setResizable(false);
        this.addWindowListener(this);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Button) {
                ((Button)componentArray[n]).addActionListener(this);
            } else if (componentArray[n] instanceof TextField) {
                ((TextField)componentArray[n]).addActionListener(this);
            } else if (componentArray[n] instanceof Checkbox) {
                ((Checkbox)componentArray[n]).addItemListener(this);
            }
            ++n;
        }
        this.proxy = proxy;
        if (this.proxy != null) {
            this.doInit(this.proxy);
        } else {
            this.ir = new InetRange();
        }
        this.dismiss_button.addActionListener(this);
        this.warning_dialog.addWindowListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancel_button) {
            this.onCancel();
        } else if (object == this.add_button || object == this.direct_text) {
            this.onAdd();
        } else if (object == this.remove_button) {
            this.onRemove();
        } else if (object == this.dismiss_button) {
            this.onDismiss();
        } else if (object == this.ok_button || object instanceof TextField) {
            this.onOK();
        }
    }

    private void doInit(Proxy proxy) {
        String[] stringArray;
        if (proxy.version == 5) {
            this.socks_group.setSelectedCheckbox(this.socks5radio);
            this.onSocksChange();
            if (((Socks5Proxy)proxy).getAuthenticationMethod(0) != null) {
                this.none_check.setState(true);
            }
            if ((stringArray = (String[])((Socks5Proxy)proxy).getAuthenticationMethod(2)) != null) {
                this.user_text.setText(stringArray.getUser());
                this.password_text.setText(stringArray.getPassword());
                this.up_check.setState(true);
                this.onUPChange();
            }
        } else {
            this.socks_group.setSelectedCheckbox(this.socks4radio);
            this.onSocksChange();
            this.user_text.setText(((Socks4Proxy)proxy).user);
        }
        this.ir = (InetRange)proxy.directHosts.clone();
        stringArray = this.ir.getAll();
        this.direct_list.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            this.direct_list.add(stringArray[n]);
            ++n;
        }
        this.host_text.setText(proxy.proxyIP.getHostName());
        this.port_text.setText(String.valueOf(proxy.proxyPort));
    }

    public Proxy getProxy() {
        this.mode = 0;
        this.pack();
        this.show();
        return this.proxy;
    }

    public Proxy getProxy(Proxy proxy) {
        if (proxy != null) {
            this.doInit(proxy);
        }
        this.mode = 0;
        this.pack();
        this.show();
        return this.proxy;
    }

    void guiInit() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Font font = new Font("Dialog", 0, 12);
        SocksDialog socksDialog = this;
        socksDialog.setLayout(new GridBagLayout());
        socksDialog.setFont(font);
        ((Component)socksDialog).setBackground(SystemColor.menu);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        Label label = new Label("Host:");
        socksDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.host_text = new TextField("socks-proxy", 15);
        socksDialog.add((Component)this.host_text, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        label = new Label("Port:");
        socksDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.port_text = new TextField("1080", 5);
        socksDialog.add((Component)this.port_text, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.socks4radio = new Checkbox("Socks4", this.socks_group, false);
        this.socks4radio.setFont(new Font(font.getName(), 1, 14));
        socksDialog.add((Component)this.socks4radio, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.socks5radio = new Checkbox("Socks5", this.socks_group, true);
        this.socks5radio.setFont(new Font(font.getName(), 1, 14));
        socksDialog.add((Component)this.socks5radio, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        label = new Label("User Id:");
        socksDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.user_text = new TextField("", 15);
        this.user_text.setEnabled(false);
        socksDialog.add((Component)this.user_text, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        label = new Label("Authentication");
        label.setFont(new Font(font.getName(), 1, 14));
        socksDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        label = new Label("Password:");
        socksDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.password_text = new TextField("", 15);
        this.password_text.setEchoChar('*');
        this.password_text.setEnabled(false);
        socksDialog.add((Component)this.password_text, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.none_check = new Checkbox("None", true);
        socksDialog.add((Component)this.none_check, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        label = new Label("Direct Hosts");
        label.setFont(new Font(font.getName(), 1, 14));
        socksDialog.add((Component)label, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.up_check = new Checkbox("User/Password", false);
        socksDialog.add((Component)this.up_check, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.direct_list = new List(3);
        socksDialog.add((Component)this.direct_list, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.gssapi_check = new Checkbox("GSSAPI", false);
        this.gssapi_check.setEnabled(false);
        socksDialog.add((Component)this.gssapi_check, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.direct_text = new TextField("", 25);
        socksDialog.add((Component)this.direct_text, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.add_button = new Button("Add");
        socksDialog.add((Component)this.add_button, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.remove_button = new Button("Remove");
        socksDialog.add((Component)this.remove_button, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.cancel_button = new Button("Cancel");
        socksDialog.add((Component)this.cancel_button, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.ok_button = new Button("OK");
        socksDialog.add((Component)this.ok_button, gridBagConstraints);
        this.dismiss_button = new Button("Dismiss");
        this.warning_label = new Label("", 1);
        this.warning_label.setFont(new Font("Dialog", 1, 15));
        Panel panel = new Panel();
        panel.add(this.dismiss_button);
        this.warning_dialog.add((Component)panel, "South");
        this.warning_dialog.add((Component)this.warning_label, "Center");
        this.warning_dialog.setResizable(false);
    }

    private void info(String string) {
        this.msgBox("Info", string);
    }

    private boolean initProxy() {
        try {
            if (this.socks_group.getSelectedCheckbox() == this.socks5radio) {
                this.proxy = new Socks5Proxy(this.host, this.port);
                if (this.up_check.getState()) {
                    ((Socks5Proxy)this.proxy).setAuthenticationMethod(2, new UserPasswordAuthentication(this.user, this.password));
                }
                if (!this.none_check.getState()) {
                    ((Socks5Proxy)this.proxy).setAuthenticationMethod(0, null);
                }
            } else {
                this.proxy = new Socks4Proxy(this.host, this.port, this.user);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        this.proxy.directHosts = this.ir;
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.socks5radio || object == this.socks4radio) {
            this.onSocksChange();
        } else if (object == this.up_check) {
            this.onUPChange();
        }
    }

    private void msgBox(String string, String string2) {
        this.warning_label.setText(string2);
        this.warning_label.invalidate();
        this.warning_dialog.setTitle(string);
        this.warning_dialog.pack();
        this.warning_dialog.show();
    }

    private void onAdd() {
        String string = this.direct_text.getText();
        string.trim();
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = this.direct_list.getItems();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return;
            }
            ++n;
        }
        this.direct_list.add(string);
        this.ir.add(string);
    }

    private void onCancel() {
        this.proxy = null;
        this.dispose();
    }

    private void onDismiss() {
        this.warning_dialog.dispose();
        if (this.mode == 1) {
            this.mode = 0;
            if (this.net_thread != null) {
                this.net_thread.interrupt();
            }
        }
    }

    private void onOK() {
        this.host = this.host_text.getText().trim();
        this.user = this.user_text.getText();
        this.password = this.password_text.getText();
        if (this.host.length() == 0) {
            this.warn("Proxy host is not set!");
            return;
        }
        if (this.socks_group.getSelectedCheckbox() == this.socks4radio) {
            if (this.user.length() == 0) {
                this.warn("User name is not set");
                return;
            }
        } else if (this.up_check.getState()) {
            if (this.user.length() == 0) {
                this.warn("User name is not set.");
                return;
            }
            if (this.password.length() == 0) {
                this.warn("Password is not set.");
                return;
            }
        } else if (!this.none_check.getState()) {
            this.warn("Please select at least one Authentication Method.");
            return;
        }
        try {
            this.port = Integer.parseInt(this.port_text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.warn("Proxy port is invalid!");
            return;
        }
        this.mode = 1;
        if (useThreads) {
            this.net_thread = new Thread(this);
            this.net_thread.start();
            this.info("Looking up host: " + this.host);
        } else if (!this.initProxy()) {
            this.warn("Proxy host is invalid.");
            this.mode = 0;
        }
        if (this.mode == 1) {
            this.dispose();
        }
    }

    private void onRemove() {
        int n = this.direct_list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.ir.remove(this.direct_list.getItem(n));
        this.direct_list.remove(n);
        this.direct_list.select(n);
    }

    private void onSocksChange() {
        Checkbox checkbox = this.socks_group.getSelectedCheckbox();
        if (checkbox == this.socks4radio) {
            this.user_text.setEnabled(true);
            this.password_text.setEnabled(false);
            this.none_check.setEnabled(false);
            this.up_check.setEnabled(false);
        } else {
            if (this.up_check.getState()) {
                this.user_text.setEnabled(true);
                this.password_text.setEnabled(true);
            } else {
                this.user_text.setEnabled(false);
                this.password_text.setEnabled(false);
            }
            this.none_check.setEnabled(true);
            this.up_check.setEnabled(true);
        }
    }

    private void onUPChange() {
        if (this.up_check.getState()) {
            this.user_text.setEnabled(true);
            this.password_text.setEnabled(true);
        } else {
            this.user_text.setEnabled(false);
            this.password_text.setEnabled(false);
        }
    }

    public void run() {
        if (!this.initProxy()) {
            if (this.mode != 1) {
                return;
            }
            if (this.net_thread != Thread.currentThread()) {
                return;
            }
            this.mode = 0;
            this.warning_label.setText("Look up failed.");
            this.warning_label.invalidate();
            return;
        }
        while (!this.warning_dialog.isShowing()) {
        }
        this.warning_dialog.dispose();
    }

    private void warn(String string) {
        this.msgBox("Warning", string);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this) {
            this.onCancel();
        } else if (window == this.warning_dialog) {
            this.onDismiss();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

