/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import java.net.URI;
import java.util.HashMap;
import org.activemq.broker.BrokerFactory;
import org.activemq.broker.BrokerService;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class DefaultBrokerFactory
implements BrokerFactory.BrokerFactoryHandler {
    public BrokerService createBroker(URI brokerURI) throws Exception {
        URISupport.CompositeData compositeData = URISupport.parseComposite(brokerURI);
        HashMap params = new HashMap(compositeData.getParameters());
        BrokerService brokerService = new BrokerService();
        IntrospectionSupport.setProperties(brokerService, params);
        URI[] components = compositeData.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if ("network".equals(components[i].getScheme())) {
                brokerService.addNetworkConnector(components[i].getSchemeSpecificPart());
                continue;
            }
            brokerService.addConnector(components[i]);
        }
        brokerService.start();
        return brokerService;
    }
}

