/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.QueueBrowserSubscription;
import org.activemq.broker.region.Region;
import org.activemq.broker.region.Subscription;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.RemoveSubscriptionInfo;
import org.activemq.filter.DestinationMap;
import org.activemq.memory.UsageManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;

public abstract class AbstractRegion
implements Region {
    protected final ConcurrentHashMap destinations = new ConcurrentHashMap();
    protected final DestinationMap destinationMap = new DestinationMap();
    protected final ConcurrentHashMap subscriptions = new ConcurrentHashMap();
    protected final UsageManager memoryManager;
    protected final PersistenceAdapter persistenceAdapter;
    protected final DestinationStatistics destinationStatistics;
    protected boolean autoCreateDestinations = true;
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final Object destinationsMutex = new Object();

    public AbstractRegion(DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        this.destinationStatistics = destinationStatistics;
        this.memoryManager = memoryManager;
        this.taskRunnerFactory = taskRunnerFactory;
        this.persistenceAdapter = persistenceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Throwable {
        Destination dest = this.createDestination(destination);
        dest.start();
        Object object = this.destinationsMutex;
        synchronized (object) {
            this.destinations.put((Object)destination, (Object)dest);
            this.destinationMap.put(destination, dest);
        }
        Iterator iter = this.subscriptions.values().iterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            if (!sub.matches(destination)) continue;
            dest.addSubscription(context, sub);
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Throwable {
        Iterator iter = this.subscriptions.values().iterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            if (!sub.matches(destination)) continue;
            throw new JMSException("Destination still has an active subscription: " + destination);
        }
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.remove((Object)destination);
            if (dest == null) {
                throw new IllegalArgumentException("The destination does not exist: " + destination);
            }
            this.destinationMap.removeAll(destination);
            dest.dispose(context);
            dest.stop();
        }
    }

    public void addConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        Subscription sub = this.createSubscription(context, info);
        if (this.persistenceAdapter != null) {
            Set inactiveDests = this.getInactiveDestinations();
            Iterator iter = inactiveDests.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination dest = (ActiveMQDestination)iter.next();
                if (!sub.matches(dest)) continue;
                context.getBroker().addDestination(context, dest);
            }
        }
        this.subscriptions.put((Object)info.getConsumerId(), (Object)sub);
        Iterator iter = this.destinationMap.get(info.getDestination()).iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.addSubscription(context, sub);
        }
        if (info.isBrowser()) {
            ((QueueBrowserSubscription)sub).browseDone();
        }
    }

    protected Set getInactiveDestinations() {
        Set inactiveDests = this.persistenceAdapter.getDestinations();
        inactiveDests.removeAll(this.destinations.keySet());
        return inactiveDests;
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        Subscription sub = (Subscription)this.subscriptions.remove((Object)info.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + info.getConsumerId());
        }
        Iterator iter = this.destinationMap.get(info.getDestination()).iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.removeSubscription(context, sub);
        }
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Throwable {
        throw new JMSException("Invalid operation.");
    }

    public void send(ConnectionContext context, Message messageSend) throws Throwable {
        Destination dest = this.lookup(context, messageSend.getDestination());
        dest.send(context, messageSend);
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Throwable {
        Subscription sub = (Subscription)this.subscriptions.get((Object)ack.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + ack.getConsumerId());
        }
        sub.acknowledge(context, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookup(ConnectionContext context, ActiveMQDestination destination) throws Throwable {
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.get((Object)destination);
            if (dest == null) {
                if (this.autoCreateDestinations) {
                    context.getBroker().addDestination(context, destination);
                    dest = (Destination)this.destinations.get((Object)destination);
                }
                if (dest == null) {
                    throw new JMSException("The destination " + destination + " does not exist.");
                }
            }
            return dest;
        }
    }

    public void gc() {
        Iterator iter = this.subscriptions.values().iterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            sub.gc();
        }
        iter = this.destinations.values().iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.gc();
        }
    }

    protected abstract Subscription createSubscription(ConnectionContext var1, ConsumerInfo var2) throws Throwable;

    protected abstract Destination createDestination(ActiveMQDestination var1) throws Throwable;

    public boolean isAutoCreateDestinations() {
        return this.autoCreateDestinations;
    }

    public void setAutoCreateDestinations(boolean autoCreateDestinations) {
        this.autoCreateDestinations = autoCreateDestinations;
    }
}

