/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.activemq.command.ActiveMQQueue;
import org.activemq.command.ActiveMQTempQueue;
import org.activemq.command.ActiveMQTempTopic;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.DataStructure;
import org.activemq.util.URISupport;

public abstract class ActiveMQDestination
implements DataStructure,
Destination,
Externalizable {
    private static final long serialVersionUID = -3885260014960795889L;
    public static final String PATH_SEPERATOR = ".";
    public static final String COMPOSITE_SEPERATOR = ",";
    public static final byte QUEUE_TYPE = 1;
    public static final byte TOPIC_TYPE = 2;
    public static final byte TEMP_MASK = 4;
    public static final byte TEMP_TOPIC_TYPE = 6;
    public static final byte TEMP_QUEUE_TYPE = 5;
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    protected String physicalName;
    protected transient ActiveMQDestination[] compositeDestinations;
    protected transient String[] destinationPaths;
    protected transient boolean isPattern;
    protected transient int hashValue;
    protected Map options;

    public ActiveMQDestination() {
    }

    protected ActiveMQDestination(String name) {
        this.setPhysicalName(name);
    }

    public ActiveMQDestination(ActiveMQDestination[] composites) {
        this.setCompositeDestinations(composites);
    }

    public boolean isComposite() {
        return this.compositeDestinations != null;
    }

    public ActiveMQDestination[] getCompositeDestinations() {
        return this.compositeDestinations;
    }

    public void setCompositeDestinations(ActiveMQDestination[] destinations) {
        this.compositeDestinations = destinations;
        this.destinationPaths = null;
        this.hashValue = 0;
        this.isPattern = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < destinations.length; ++i) {
            if (i != 0) {
                sb.append(COMPOSITE_SEPERATOR);
            }
            if (this.getDestinationType() == destinations[i].getDestinationType()) {
                sb.append(destinations[i].getQualifiedName());
                continue;
            }
            sb.append(destinations[i].getQualifiedName());
        }
        this.physicalName = sb.toString();
    }

    public String getQualifiedName() {
        if (this.isComposite()) {
            return this.physicalName;
        }
        return this.getQualifiedPrefix() + this.physicalName;
    }

    protected abstract String getQualifiedPrefix();

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        int p = physicalName.indexOf("?");
        if (p >= 0) {
            String optstring = physicalName.substring(p + 1);
            physicalName = physicalName.substring(0, p);
            try {
                this.options = URISupport.parseQuery(optstring);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid destination name: " + physicalName + ", it's options are not encoded properly: " + e);
            }
        }
        this.physicalName = physicalName;
        this.destinationPaths = null;
        this.hashValue = 0;
        this.isPattern = false;
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer iter = new StringTokenizer(physicalName, COMPOSITE_SEPERATOR);
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() == 0) continue;
            l.add(name);
        }
        if (l.size() > 1) {
            this.compositeDestinations = new ActiveMQDestination[l.size()];
            int counter = 0;
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                this.compositeDestinations[counter++] = this.createDestination((String)iterator.next());
            }
        } else {
            this.compositeDestinations = null;
            if (!(this.isTemporary() || physicalName.indexOf("*") < 0 && physicalName.indexOf("<") < 0)) {
                this.isPattern = true;
            }
        }
    }

    public ActiveMQDestination createDestination(String name) {
        return ActiveMQDestination.createDestination(name, this.getDestinationType());
    }

    public static ActiveMQDestination createDestination(String name, byte defaultType) {
        if (name.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            return new ActiveMQQueue(name.substring(QUEUE_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TOPIC_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            return new ActiveMQTempQueue(name.substring(TEMP_QUEUE_QUALIFED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            return new ActiveMQTempTopic(name.substring(TEMP_TOPIC_QUALIFED_PREFIX.length()));
        }
        switch (defaultType) {
            case 1: {
                return new ActiveMQQueue(name);
            }
            case 2: {
                return new ActiveMQTopic(name);
            }
            case 5: {
                return new ActiveMQTempQueue(name);
            }
            case 6: {
                return new ActiveMQTempTopic(name);
            }
        }
        throw new IllegalArgumentException("Invalid default destination type: " + defaultType);
    }

    public String[] getDestinationPaths() {
        if (this.destinationPaths != null) {
            return this.destinationPaths;
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer iter = new StringTokenizer(this.physicalName, PATH_SEPERATOR);
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() == 0) continue;
            l.add(name);
        }
        this.destinationPaths = new String[l.size()];
        l.toArray(this.destinationPaths);
        return this.destinationPaths;
    }

    public abstract byte getDestinationType();

    public boolean isQueue() {
        return false;
    }

    public boolean isTopic() {
        return false;
    }

    public boolean isTemporary() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveMQDestination d = (ActiveMQDestination)o;
        return this.physicalName.equals(d.physicalName);
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = this.physicalName.hashCode();
        }
        return this.hashValue;
    }

    public static ActiveMQDestination transform(Destination dest) throws JMSException {
        if (dest == null) {
            return null;
        }
        if (dest instanceof ActiveMQDestination) {
            return (ActiveMQDestination)dest;
        }
        if (dest instanceof TemporaryQueue) {
            return new ActiveMQTempQueue(((TemporaryQueue)dest).getQueueName());
        }
        if (dest instanceof TemporaryTopic) {
            return new ActiveMQTempTopic(((TemporaryTopic)dest).getTopicName());
        }
        if (dest instanceof Queue) {
            return new ActiveMQQueue(((Queue)dest).getQueueName());
        }
        if (dest instanceof Topic) {
            return new ActiveMQTopic(((Topic)dest).getTopicName());
        }
        throw new JMSException("Could not transform the destination into a ActiveMQ destination: " + dest);
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getPhysicalName());
        out.writeObject(this.options);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setPhysicalName(in.readUTF());
        this.options = (Map)in.readObject();
    }

    public String getDestinationTypeAsString() {
        switch (this.getDestinationType()) {
            case 1: {
                return "Queue";
            }
            case 2: {
                return "Topic";
            }
            case 5: {
                return "TempQueue";
            }
            case 6: {
                return "TempTopic";
            }
        }
        throw new IllegalArgumentException("Invalid destination type: " + this.getDestinationType());
    }

    public Map getOptions() {
        return this.options;
    }

    public boolean isMarshallAware() {
        return false;
    }
}

