/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.activeio.ByteArrayInputStream;
import org.activeio.ByteArrayOutputStream;
import org.activeio.ByteSequence;
import org.activemq.ActiveMQConnection;
import org.activemq.command.ActiveMQMessage;
import org.activemq.command.Message;
import org.activemq.util.ClassLoading;
import org.activemq.util.JMSExceptionSupport;

public class ActiveMQObjectMessage
extends ActiveMQMessage
implements ObjectMessage {
    private static final ClassLoader ACTIVEMQ_CLASSLOADER = ActiveMQObjectMessage.class.getClassLoader();
    public static final byte DATA_STRUCTURE_TYPE = 26;
    protected transient Serializable object;

    public Message copy() {
        ActiveMQObjectMessage copy = new ActiveMQObjectMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQObjectMessage copy) {
        this.storeContent();
        super.copy(copy);
        copy.object = null;
    }

    public void storeContent() {
        ByteSequence bodyAsBytes = this.getContent();
        if (bodyAsBytes == null && this.object != null) {
            try {
                ByteArrayOutputStream bytesOut;
                Object os = bytesOut = new ByteArrayOutputStream();
                ActiveMQConnection connection = this.getConnection();
                if (connection != null && connection.isUseCompression()) {
                    this.compressed = true;
                    os = new DeflaterOutputStream((OutputStream)os);
                }
                DataOutputStream dataOut = new DataOutputStream((OutputStream)os);
                ObjectOutputStream objOut = new ObjectOutputStream(dataOut);
                objOut.writeObject(this.object);
                objOut.close();
                this.setContent(bytesOut.toByteSequence());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
        }
    }

    public byte getDataStructureType() {
        return 26;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.object = null;
    }

    public void setObject(Serializable newObject) throws JMSException {
        this.checkReadOnlyBody();
        this.object = newObject;
        this.setContent(null);
        ActiveMQConnection connection = this.getConnection();
        if (connection == null || !connection.isObjectMessageSerializationDefered()) {
            this.storeContent();
        }
    }

    public Serializable getObject() throws JMSException {
        if (this.object == null && this.getContent() != null) {
            try {
                ByteSequence content = this.getContent();
                Object is = new ByteArrayInputStream(content);
                if (this.isCompressed()) {
                    is = new InflaterInputStream((InputStream)is);
                }
                DataInputStream dataIn = new DataInputStream((InputStream)is);
                ObjectInputStreamExt objIn = new ObjectInputStreamExt(dataIn);
                try {
                    this.object = (Serializable)objIn.readObject();
                }
                catch (ClassNotFoundException ce) {
                    throw new IOException(ce.getMessage());
                }
                dataIn.close();
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create("Failed to build body from bytes. Reason: " + e, e);
            }
        }
        return this.object;
    }

    public String toString() {
        try {
            this.getObject();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return super.toString();
    }

    public static class ObjectInputStreamExt
    extends ObjectInputStream {
        public ObjectInputStreamExt(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return this.load(classDesc.getName(), cl);
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class[] cinterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                cinterfaces[i] = this.load(interfaces[i], cl);
            }
            try {
                return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }

        private Class load(String className, ClassLoader cl) throws ClassNotFoundException {
            try {
                return ClassLoading.loadClass(className, cl);
            }
            catch (ClassNotFoundException e) {
                return ClassLoading.loadClass(className, ACTIVEMQ_CLASSLOADER);
            }
        }
    }
}

