/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import org.activemq.command.ConnectionId;
import org.activemq.command.TransactionId;

public class LocalTransactionId
extends TransactionId {
    public static final byte DATA_STRUCTURE_TYPE = 111;
    protected ConnectionId connectionId;
    protected long transactionId;
    private transient String transactionKey;
    private transient int hashCode;

    public LocalTransactionId() {
    }

    public LocalTransactionId(ConnectionId connectionId, long transactionId) {
        this.connectionId = connectionId;
        this.transactionId = transactionId;
    }

    public byte getDataStructureType() {
        return 111;
    }

    public boolean isXATransaction() {
        return false;
    }

    public boolean isLocalTransaction() {
        return true;
    }

    public String getTransactionKey() {
        if (this.transactionKey == null) {
            this.transactionKey = "TX:" + this.connectionId + ":" + this.transactionId;
        }
        return this.transactionKey;
    }

    public String toString() {
        return this.getTransactionKey();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.connectionId.hashCode() ^ (int)this.transactionId;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != LocalTransactionId.class) {
            return false;
        }
        LocalTransactionId tx = (LocalTransactionId)o;
        return this.transactionId == tx.transactionId && this.connectionId.equals(tx.connectionId);
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(ConnectionId connectionId) {
        this.connectionId = connectionId;
    }
}

