/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.activeio.ByteArrayInputStream;
import org.activeio.ByteArrayOutputStream;
import org.activeio.ByteSequence;
import org.activeio.command.WireFormat;
import org.activemq.ActiveMQConnection;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.MessageReference;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BaseCommand;
import org.activemq.command.BrokerId;
import org.activemq.command.ConsumerId;
import org.activemq.command.DataStructure;
import org.activemq.command.MarshallAware;
import org.activemq.command.MessageId;
import org.activemq.command.ProducerId;
import org.activemq.command.TransactionId;
import org.activemq.util.MarshallingSupport;

public abstract class Message
extends BaseCommand
implements MarshallAware,
MessageReference {
    public static final int AVERAGE_MESSAGE_SIZE_OVERHEAD = 300;
    protected MessageId messageId;
    protected ActiveMQDestination originalDestination;
    protected TransactionId originalTransactionId;
    protected ProducerId producerId;
    protected ActiveMQDestination destination;
    protected TransactionId transactionId;
    protected long expiration;
    protected long timestamp;
    protected long arrival;
    protected String correlationId;
    protected ActiveMQDestination replyTo;
    protected boolean persistent;
    protected String type;
    protected byte priority;
    protected String groupID;
    protected int groupSequence;
    protected ConsumerId targetConsumerId;
    protected boolean compressed = false;
    protected String userID;
    protected ByteSequence content;
    protected ByteSequence marshalledProperties;
    protected DataStructure dataStructure;
    protected int redeliveryCounter;
    protected transient int size;
    protected transient HashMap properties;
    protected transient boolean readOnlyProperties = false;
    protected transient boolean readOnlyBody = false;
    private BrokerId[] brokerPath;
    private transient short referenceCount;
    private transient ActiveMQConnection connection;
    private transient Destination regionDestination;
    private WireFormat cachedWireFormat;
    private ByteSequence cachedWireFormatData;

    public abstract Message copy();

    protected void copy(Message copy) {
        super.copy(copy);
        copy.producerId = this.producerId;
        copy.transactionId = this.transactionId;
        copy.destination = this.destination;
        copy.messageId = this.messageId;
        copy.originalDestination = this.originalDestination;
        copy.originalTransactionId = this.originalTransactionId;
        copy.expiration = this.expiration;
        copy.timestamp = this.timestamp;
        copy.correlationId = this.correlationId;
        copy.replyTo = this.replyTo;
        copy.persistent = this.persistent;
        copy.redeliveryCounter = this.redeliveryCounter;
        copy.type = this.type;
        copy.priority = this.priority;
        copy.size = this.size;
        copy.groupID = this.groupID;
        copy.userID = this.userID;
        copy.groupSequence = this.groupSequence;
        copy.properties = this.properties != null ? new HashMap(this.properties) : this.properties;
        copy.content = this.content;
        copy.marshalledProperties = this.marshalledProperties;
        copy.dataStructure = this.dataStructure;
        copy.readOnlyProperties = this.readOnlyProperties;
        copy.readOnlyBody = this.readOnlyBody;
        copy.compressed = this.compressed;
    }

    public Object getProperty(String name) throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return null;
            }
            this.properties = this.unmarsallProperties(this.marshalledProperties);
        }
        return this.properties.get(name);
    }

    public Map getProperties() throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                return Collections.EMPTY_MAP;
            }
            this.properties = this.unmarsallProperties(this.marshalledProperties);
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public void clearProperties() {
        this.marshalledProperties = null;
        this.properties = null;
    }

    public void setProperty(String name, Object value) throws IOException {
        if (this.properties == null) {
            if (this.marshalledProperties == null) {
                this.properties = new HashMap();
            } else {
                this.properties = this.unmarsallProperties(this.marshalledProperties);
                this.marshalledProperties = null;
            }
        }
        this.properties.put(name, value);
    }

    private HashMap unmarsallProperties(ByteSequence marshalledProperties) throws IOException {
        return MarshallingSupport.unmarshalPrimitiveMap(new DataInputStream((InputStream)new ByteArrayInputStream(marshalledProperties)));
    }

    public void beforeMarshall(WireFormat wireFormat) throws IOException {
        if (this.marshalledProperties == null && this.properties != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream((OutputStream)baos);
            MarshallingSupport.marshalPrimitiveMap(this.properties, os);
            os.close();
            this.marshalledProperties = baos.toByteSequence();
        }
    }

    public void afterMarshall(WireFormat wireFormat) throws IOException {
    }

    public void beforeUnmarshall(WireFormat wireFormat) throws IOException {
    }

    public void afterUnmarshall(WireFormat wireFormat) throws IOException {
    }

    public int getSize() {
        if (this.size == 0) {
            this.size = 300;
            if (this.marshalledProperties != null) {
                this.size += this.marshalledProperties.getLength();
            }
            if (this.content != null) {
                this.size += this.content.getLength();
            }
        }
        return this.size;
    }

    public ProducerId getProducerId() {
        return this.producerId;
    }

    public void setProducerId(ProducerId producerId) {
        this.producerId = producerId;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(TransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    public ActiveMQDestination getOriginalDestination() {
        return this.originalDestination;
    }

    public void setOriginalDestination(ActiveMQDestination destination) {
        this.originalDestination = destination;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public void setMessageId(MessageId messageId) {
        this.messageId = messageId;
    }

    public TransactionId getOriginalTransactionId() {
        return this.originalTransactionId;
    }

    public void setOriginalTransactionId(TransactionId transactionId) {
        this.originalTransactionId = transactionId;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public int getGroupSequence() {
        return this.groupSequence;
    }

    public void setGroupSequence(int groupSequence) {
        this.groupSequence = groupSequence;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean deliveryMode) {
        this.persistent = deliveryMode;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public ActiveMQDestination getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(ActiveMQDestination replyTo) {
        this.replyTo = replyTo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ByteSequence getContent() {
        return this.content;
    }

    public void setContent(ByteSequence content) {
        this.content = content;
    }

    public ByteSequence getMarshalledProperties() {
        return this.marshalledProperties;
    }

    public void setMarshalledProperties(ByteSequence marshalledProperties) {
        this.marshalledProperties = marshalledProperties;
    }

    public DataStructure getDataStructure() {
        return this.dataStructure;
    }

    public void setDataStructure(DataStructure data) {
        this.dataStructure = data;
    }

    public ConsumerId getTargetConsumerId() {
        return this.targetConsumerId;
    }

    public void setTargetConsumerId(ConsumerId targetConsumerId) {
        this.targetConsumerId = targetConsumerId;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isRedelivered() {
        return this.redeliveryCounter > 0;
    }

    public void setRedelivered(boolean redelivered) {
        if (redelivered) {
            if (!this.isRedelivered()) {
                this.setRedeliveryCounter(1);
            }
        } else if (this.isRedelivered()) {
            this.setRedeliveryCounter(0);
        }
    }

    public void incrementRedeliveryCounter() {
        ++this.redeliveryCounter;
    }

    public int getRedeliveryCounter() {
        return this.redeliveryCounter;
    }

    public void setRedeliveryCounter(int deliveryCounter) {
        this.redeliveryCounter = deliveryCounter;
    }

    public BrokerId[] getBrokerPath() {
        return this.brokerPath;
    }

    public void setBrokerPath(BrokerId[] brokerPath) {
        this.brokerPath = brokerPath;
    }

    public boolean isReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public void setReadOnlyProperties(boolean readOnlyProperties) {
        this.readOnlyProperties = readOnlyProperties;
    }

    public boolean isReadOnlyBody() {
        return this.readOnlyBody;
    }

    public void setReadOnlyBody(boolean readOnlyBody) {
        this.readOnlyBody = readOnlyBody;
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ActiveMQConnection connection) {
        this.connection = connection;
    }

    public long getArrival() {
        return this.arrival;
    }

    public void setArrival(long arrival) {
        this.arrival = arrival;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String jmsxUserID) {
        this.userID = jmsxUserID;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementReferenceCount() {
        short rc;
        Message message = this;
        synchronized (message) {
            rc = this.referenceCount = (short)(this.referenceCount + 1);
        }
        if (rc == 1 && this.regionDestination != null) {
            this.regionDestination.getUsageManager().increaseUsage(this.getSize());
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int decrementReferenceCount() {
        short rc;
        Message message = this;
        synchronized (message) {
            rc = this.referenceCount = (short)(this.referenceCount - 1);
        }
        if (rc == 0 && this.regionDestination != null) {
            this.regionDestination.getUsageManager().decreaseUsage(this.getSize());
        }
        return rc;
    }

    public Message getMessageHardRef() {
        return this;
    }

    public Message getMessage() throws IOException {
        return this;
    }

    public Destination getRegionDestination() {
        return this.regionDestination;
    }

    public void setRegionDestination(Destination destination) {
        this.regionDestination = destination;
    }

    public boolean isMarshallAware() {
        return true;
    }

    public void setCachedMarshalledForm(WireFormat wireFormat, ByteSequence data) {
        this.cachedWireFormat = wireFormat;
        this.cachedWireFormatData = data;
    }

    public ByteSequence getCachedMarshalledForm(WireFormat wireFormat) {
        if (this.cachedWireFormat == null || !this.cachedWireFormat.equals(wireFormat)) {
            return null;
        }
        return this.cachedWireFormatData;
    }
}

