/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.memory;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.activemq.memory.Cache;
import org.activemq.memory.CacheFilter;
import org.activemq.memory.UsageManager;

public class UsageManagerCacheFilter
extends CacheFilter {
    private final AtomicLong totalUsage = new AtomicLong(0L);
    private final UsageManager um;

    public UsageManagerCacheFilter(Cache next, UsageManager um) {
        super(next);
        this.um = um;
    }

    public Object put(Object key, Object value) {
        long usage = this.getUsageOfAddedObject(value);
        Object rc = super.put(key, value);
        if (rc != null) {
            usage -= this.getUsageOfRemovedObject(rc);
        }
        this.totalUsage.addAndGet(usage);
        this.um.increaseUsage(usage);
        return rc;
    }

    public Object remove(Object key) {
        Object rc = super.remove(key);
        if (rc != null) {
            long usage = this.getUsageOfRemovedObject(rc);
            this.totalUsage.addAndGet(-usage);
            this.um.decreaseUsage(usage);
        }
        return rc;
    }

    protected long getUsageOfAddedObject(Object value) {
        return 1L;
    }

    protected long getUsageOfRemovedObject(Object value) {
        return 1L;
    }

    public void close() {
        this.um.decreaseUsage(this.totalUsage.get());
    }
}

