/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.activemq.Service;
import org.activemq.command.DiscoveryEvent;
import org.activemq.network.Bridge;
import org.activemq.network.DemandForwardingBridge;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.discovery.DiscoveryAgent;
import org.activemq.transport.discovery.DiscoveryAgentFactory;
import org.activemq.transport.discovery.DiscoveryListener;
import org.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkConnector
implements Service,
DiscoveryListener {
    private static final Log log = LogFactory.getLog((Class)NetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private URI localURI;
    private ConcurrentHashMap bridges = new ConcurrentHashMap();

    public NetworkConnector() {
    }

    public NetworkConnector(URI localURI, DiscoveryAgent discoveryAgent) throws IOException {
        this.localURI = localURI;
        this.setDiscoveryAgent(discoveryAgent);
    }

    public void start() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        if (this.localURI == null) {
            throw new IllegalStateException("You must configure the 'localURI' property");
        }
        this.discoveryAgent.start();
    }

    public void stop() throws Exception {
        this.discoveryAgent.stop();
    }

    public void onServiceAdd(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            Transport remoteTransport;
            Transport localTransport;
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            if (this.bridges.containsKey((Object)uri) || this.localURI.equals(uri)) {
                return;
            }
            log.info((Object)("Establishing network connection between " + this.localURI + " and " + uri));
            try {
                localTransport = TransportFactory.connect(this.localURI);
            }
            catch (Exception e) {
                log.warn((Object)("Could not connect to local URI: " + this.localURI + ": " + e), (Throwable)e);
                return;
            }
            try {
                remoteTransport = TransportFactory.connect(uri);
            }
            catch (Exception e) {
                ServiceSupport.dispose(localTransport);
                log.warn((Object)("Could not connect to remote URI: " + uri + ": " + e), (Throwable)e);
                return;
            }
            Bridge bridge = this.createBridge(localTransport, remoteTransport);
            this.bridges.put((Object)uri, (Object)bridge);
            try {
                bridge.start();
            }
            catch (Exception e) {
                ServiceSupport.dispose(localTransport);
                ServiceSupport.dispose(remoteTransport);
                log.warn((Object)("Could not start network bridge between: " + this.localURI + " and: " + uri + " due to: " + e), (Throwable)e);
                return;
            }
        }
    }

    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            Bridge bridge = (Bridge)this.bridges.get((Object)uri);
            if (bridge == null) {
                return;
            }
            ServiceSupport.dispose(bridge);
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener(this);
        }
    }

    public URI getLocalUri() throws URISyntaxException {
        return this.localURI;
    }

    public void setLocalUri(URI localURI) {
        this.localURI = localURI;
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent(discoveryURI));
    }

    protected Bridge createBridge(Transport localTransport, Transport remoteTransport) {
        return new DemandForwardingBridge(localTransport, remoteTransport);
    }
}

