/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.ProducerId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class ProducerIdMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 123;
    }

    public DataStructure createObject() {
        return new ProducerId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        ProducerId info = (ProducerId)o;
        info.setConnectionId(this.readString(dataIn, bs));
        info.setProducerId(bs.readBoolean() ? dataIn.readLong() : 0L);
        info.setSessionId(bs.readBoolean() ? dataIn.readLong() : 0L);
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ProducerId info = (ProducerId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.writeString(info.getConnectionId(), bs);
        bs.writeBoolean(info.getProducerId() != 0L);
        rc += info.getProducerId() != 0L ? 8 : 0;
        bs.writeBoolean(info.getSessionId() != 0L);
        return (rc += info.getSessionId() != 0L ? 8 : 0) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        ProducerId info = (ProducerId)o;
        this.writeString(info.getConnectionId(), dataOut, bs);
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getProducerId());
        }
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getSessionId());
        }
    }
}

