/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ConnectionId;
import org.activemq.command.DataStructure;
import org.activemq.command.TransactionId;
import org.activemq.command.TransactionInfo;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class TransactionInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 7;
    }

    public DataStructure createObject() {
        return new TransactionInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        TransactionInfo info = (TransactionInfo)o;
        info.setConnectionId((ConnectionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setTransactionId((TransactionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setType(dataIn.readByte());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        TransactionInfo info = (TransactionInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getConnectionId(), bs);
        return (rc += this.marshal1CachedObject(wireFormat, info.getTransactionId(), bs)) + 1;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        TransactionInfo info = (TransactionInfo)o;
        this.marshal2CachedObject(wireFormat, info.getConnectionId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getTransactionId(), dataOut, bs);
        dataOut.writeByte(info.getType());
    }
}

