/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.failover;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.state.ConnectionStateTracker;
import org.activemq.thread.DefaultThreadPools;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportListener;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailoverTransport
implements Transport {
    private static final Log log = LogFactory.getLog((Class)FailoverTransport.class);
    private TransportListener transportListener;
    private boolean disposed;
    private final CopyOnWriteArrayList uris = new CopyOnWriteArrayList();
    private final Object reconnectMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final ConcurrentHashMap requestMap = new ConcurrentHashMap();
    private URI connectedTransportURI;
    private Transport connectedTransport;
    private final TaskRunner reconnectTask;
    private boolean started;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts;
    private int connectFailures;
    private long reconnectDelay = this.initialReconnectDelay;
    private Exception connectionFailure;
    private final TransportListener myTransportListener = new TransportListener(){

        public void onCommand(Command command) {
            if (command.isResponse()) {
                FailoverTransport.this.requestMap.remove((Object)new Short(((Response)command).getCorrelationId()));
            }
            FailoverTransport.this.transportListener.onCommand(command);
        }

        public void onException(IOException error) {
            try {
                FailoverTransport.this.handleTransportFailure(error);
            }
            catch (InterruptedException e) {
                FailoverTransport.this.transportListener.onException(new InterruptedIOException());
            }
        }
    };

    public FailoverTransport() throws InterruptedIOException {
        this.reconnectTask = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean iterate() {
                Exception failure = null;
                Object object = FailoverTransport.this.reconnectMutex;
                synchronized (object) {
                    if (FailoverTransport.this.disposed || FailoverTransport.this.connectionFailure != null) {
                        FailoverTransport.this.reconnectMutex.notifyAll();
                    }
                    if (FailoverTransport.this.connectedTransport != null || FailoverTransport.this.disposed || FailoverTransport.this.connectionFailure != null) {
                        return false;
                    }
                    ArrayList connectList = FailoverTransport.this.getConnectList();
                    if (connectList.isEmpty()) {
                        failure = new IOException("No uris available to connect to.");
                    } else {
                        Iterator iter = connectList.iterator();
                        int i = 0;
                        while (iter.hasNext() && FailoverTransport.this.connectedTransport == null && !FailoverTransport.this.disposed) {
                            URI uri = (URI)iter.next();
                            try {
                                log.debug((Object)("Attempting connect to: " + uri));
                                Transport t = TransportFactory.compositeConnect(uri);
                                t.setTransportListener(FailoverTransport.this.myTransportListener);
                                if (FailoverTransport.this.started) {
                                    FailoverTransport.this.restoreTransport(t);
                                }
                                log.debug((Object)"Connection established");
                                FailoverTransport.this.reconnectDelay = 10L;
                                FailoverTransport.this.connectedTransportURI = uri;
                                FailoverTransport.this.connectedTransport = t;
                                FailoverTransport.this.reconnectMutex.notifyAll();
                                FailoverTransport.this.connectFailures = 0;
                                return false;
                            }
                            catch (Exception e) {
                                failure = e;
                                log.debug((Object)("Connect fail to: " + uri + ", reason: " + e));
                                ++i;
                            }
                        }
                    }
                    if (FailoverTransport.this.maxReconnectAttempts > 0 && ++FailoverTransport.this.connectFailures >= FailoverTransport.this.maxReconnectAttempts) {
                        log.error((Object)("Failed to connect to transport after: " + FailoverTransport.this.connectFailures + " attempt(s)"));
                        FailoverTransport.this.connectionFailure = failure;
                        FailoverTransport.this.reconnectMutex.notifyAll();
                        return false;
                    }
                }
                try {
                    log.debug((Object)("Waiting " + FailoverTransport.this.reconnectDelay + " ms before attempting connection. "));
                    Thread.sleep(FailoverTransport.this.reconnectDelay);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (FailoverTransport.this.useExponentialBackOff) {
                    FailoverTransport.this.reconnectDelay *= FailoverTransport.this.backOffMultiplier;
                    if (FailoverTransport.this.reconnectDelay > FailoverTransport.this.maxReconnectDelay) {
                        FailoverTransport.this.reconnectDelay = FailoverTransport.this.maxReconnectDelay;
                    }
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransportFailure(IOException e) throws InterruptedException {
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Transport failed, starting up reconnect task", (Throwable)e);
            if (this.connectedTransport != null) {
                ServiceSupport.dispose(this.connectedTransport);
                this.connectedTransport = null;
                this.connectedTransportURI = null;
                this.reconnectTask.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Started.");
            if (this.started) {
                return;
            }
            this.started = true;
            if (this.connectedTransport != null) {
                this.connectedTransport.start();
                this.stateTracker.restore(this.connectedTransport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Stopped.");
            if (!this.started) {
                return;
            }
            this.started = false;
            this.disposed = true;
            if (this.connectedTransport != null) {
                this.connectedTransport.stop();
            }
        }
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public long getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(long reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public Transport getConnectedTransport() {
        return this.connectedTransport;
    }

    public URI getConnectedTransportURI() {
        return this.connectedTransportURI;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Command command) throws IOException {
        Exception error = null;
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                int i = 0;
                while (true) {
                    try {
                        while (this.connectedTransport == null && !this.disposed && this.connectionFailure == null) {
                            log.debug((Object)"Waiting for transport to reconnect.");
                            this.reconnectMutex.wait(1000L);
                        }
                        if (this.connectedTransport == null) {
                            error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : new IOException("Unexpected failure."));
                            break;
                        }
                        this.connectedTransport.oneway(command);
                        if (!this.stateTracker.track(command) && command.isResponseRequired()) {
                            this.requestMap.put((Object)new Short(command.getCommandId()), (Object)command);
                        }
                        return;
                    }
                    catch (IOException e) {
                        log.debug((Object)("Send oneway attempt: " + i + " failed."));
                        this.handleTransportFailure(e);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (error instanceof IOException) {
            throw error;
        }
        throw IOExceptionSupport.create(error);
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public CopyOnWriteArrayList getURIs() {
        return this.uris;
    }

    public void reconnect() throws InterruptedException {
        log.debug((Object)"Waking up reconnect task");
        this.reconnectTask.wakeup();
    }

    private ArrayList getConnectList() {
        ArrayList l = new ArrayList(this.uris);
        Random r = new Random();
        r.setSeed(System.currentTimeMillis());
        for (int i = 0; i < l.size(); ++i) {
            int p = r.nextInt(l.size());
            Object t = l.get(p);
            l.set(p, l.get(i));
            l.set(i, t);
        }
        return l;
    }

    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.connectedTransport != null) {
                return this.connectedTransport.narrow(target);
            }
        }
        return null;
    }

    protected void restoreTransport(Transport t) throws Exception, IOException {
        t.start();
        this.stateTracker.restore(t);
        Iterator iter2 = this.requestMap.values().iterator();
        while (iter2.hasNext()) {
            Command command = (Command)iter2.next();
            t.oneway(command);
        }
    }
}

