/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.peer;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.activemq.transport.vm.VMTransportFactory;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.URISupport;

public class PeerTransportFactory
extends TransportFactory {
    VMTransportFactory vmTransportFactory = new VMTransportFactory();
    public static final ConcurrentHashMap brokers = new ConcurrentHashMap();
    public static final ConcurrentHashMap connectors = new ConcurrentHashMap();
    public static final ConcurrentHashMap servers = new ConcurrentHashMap();

    public Transport doConnect(URI location) throws Exception {
        location = this.convertURI(location);
        return this.vmTransportFactory.doConnect(location);
    }

    public Transport doCompositeConnect(URI location) throws Exception {
        location = this.convertURI(location);
        return this.vmTransportFactory.doCompositeConnect(location);
    }

    private URI convertURI(URI location) throws IOException {
        try {
            String broker = location.getHost();
            String group = location.getPath();
            if (group == null) {
                group = "default";
            }
            HashMap<String, String> brokerOptions = new HashMap<String, String>(URISupport.parseParamters(location));
            brokerOptions.put("brokerName", broker);
            HashMap<String, String> networkOptions = new HashMap<String, String>();
            networkOptions.put("group", group);
            location = new URI("vm:broker:(discovery:tcp://localhost:0,network:rendezvous?" + URISupport.createQueryString(networkOptions) + ")?" + URISupport.createQueryString(brokerOptions));
            return location;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public TransportServer doBind(URI location) throws IOException {
        throw new IOException("This protocol does not support being bound.");
    }
}

