/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.util.Iterator;
import java.util.List;
import org.activemq.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceStopper {
    private Exception firstException;

    public void stop(Service service) {
        try {
            service.stop();
        }
        catch (Exception e) {
            this.onException(service, e);
        }
    }

    public void stopServices(List services) {
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            Service service = (Service)iter.next();
            this.stop(service);
        }
    }

    public void onException(Object owner, Exception e) {
        this.logError(owner, e);
        if (this.firstException == null) {
            this.firstException = e;
        }
    }

    public void throwFirstException() throws Exception {
        if (this.firstException != null) {
            throw this.firstException;
        }
    }

    protected void logError(Object service, Exception e) {
        Log log = LogFactory.getLog(service.getClass());
        log.error((Object)("Could not stop service: " + service + ". Reason: " + e), (Throwable)e);
    }
}

