/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.filter.BooleanExpression;
import org.activemq.filter.DestinationFilter;
import org.activemq.filter.LogicExpression;
import org.activemq.filter.MessageEvaluationContext;
import org.activemq.filter.NoLocalExpression;
import org.activemq.selector.SelectorParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSubscription
implements Subscription {
    protected final Log log;
    protected ConnectionContext context;
    protected ConsumerInfo info;
    protected final DestinationFilter destinationFilter;
    protected final BooleanExpression selector;
    protected final CopyOnWriteArrayList destinations = new CopyOnWriteArrayList();

    public AbstractSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this.context = context;
        this.info = info;
        this.destinationFilter = DestinationFilter.parseFilter(info.getDestination());
        this.selector = AbstractSubscription.parseSelector(info);
        this.log = LogFactory.getLog((String)(this.getClass().getName() + "." + info.getConsumerId()));
    }

    private static BooleanExpression parseSelector(ConsumerInfo info) throws InvalidSelectorException {
        BooleanExpression rc = null;
        if (info.getSelector() != null) {
            rc = new SelectorParser().parse(info.getSelector());
        }
        if (info.isNoLocal()) {
            rc = rc == null ? new NoLocalExpression(info.getConsumerId().getConnectionId()) : LogicExpression.createAND(new NoLocalExpression(info.getConsumerId().getConnectionId()), rc);
        }
        if (info.getAdditionalPredicate() != null) {
            rc = rc == null ? info.getAdditionalPredicate() : LogicExpression.createAND(info.getAdditionalPredicate(), rc);
        }
        return rc;
    }

    public boolean matches(MessageReference node, MessageEvaluationContext context) {
        ConsumerId targetConsumerId = node.getTargetConsumerId();
        if (targetConsumerId != null && !targetConsumerId.equals(this.info.getConsumerId())) {
            return false;
        }
        try {
            return this.selector == null || this.selector.matches(context);
        }
        catch (JMSException e) {
            this.log.info((Object)("Selector failed to evaluate: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public boolean matches(ActiveMQDestination destination) {
        return this.destinationFilter.matches(destination);
    }

    public void add(ConnectionContext context, Destination destination) throws Throwable {
        this.destinations.add((Object)destination);
    }

    public void remove(ConnectionContext context, Destination destination) throws Throwable {
        this.destinations.remove((Object)destination);
    }

    public ConsumerInfo getConsumerInfo() {
        return this.info;
    }

    public void gc() {
    }
}

