/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import org.activemq.command.DataStructure;
import org.activemq.command.ProducerId;
import org.activemq.command.ProducerInfo;

public class MessageId
implements DataStructure {
    public static final byte DATA_STRUCTURE_TYPE = 110;
    protected ProducerId producerId;
    protected long producerSequenceId;
    protected long brokerSequenceId;
    private transient String key;
    private transient int hashCode;

    public MessageId() {
        this.producerId = new ProducerId();
    }

    public MessageId(ProducerInfo producerInfo, long producerSequenceId) {
        this.producerId = producerInfo.getProducerId();
        this.producerSequenceId = producerSequenceId;
    }

    public MessageId(String messageKey) {
        this.setMessageKey(messageKey);
    }

    public MessageId(String producerId, long producerSequenceId) {
        this(new ProducerId(producerId), producerSequenceId);
    }

    public MessageId(ProducerId producerId, long producerSequenceId) {
        this.producerId = producerId;
        this.producerSequenceId = producerSequenceId;
    }

    public void setMessageKey(String messageKey) {
        this.key = messageKey;
        int p = messageKey.lastIndexOf(":");
        if (p >= 0) {
            this.producerSequenceId = Long.parseLong(messageKey.substring(p + 1));
            messageKey = messageKey.substring(0, p);
        }
        this.producerId = new ProducerId(messageKey);
    }

    public byte getDataStructureType() {
        return 110;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MessageId id = (MessageId)o;
        return this.producerSequenceId == id.producerSequenceId && this.producerId.equals(id.producerId);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.producerId.hashCode() ^ (int)this.producerSequenceId;
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.producerId.toString() + ":" + this.producerSequenceId;
        }
        return this.key;
    }

    public ProducerId getProducerId() {
        return this.producerId;
    }

    public void setProducerId(ProducerId producerId) {
        this.producerId = producerId;
    }

    public long getProducerSequenceId() {
        return this.producerSequenceId;
    }

    public void setProducerSequenceId(long producerSequenceId) {
        this.producerSequenceId = producerSequenceId;
    }

    public long getBrokerSequenceId() {
        return this.brokerSequenceId;
    }

    public void setBrokerSequenceId(long brokerSequenceId) {
        this.brokerSequenceId = brokerSequenceId;
    }

    public boolean isMarshallAware() {
        return false;
    }
}

