/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.io.IOException;
import javax.jms.JMSException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.filter.BooleanExpression;
import org.activemq.filter.CompositeDestinationFilter;
import org.activemq.filter.DestinationPath;
import org.activemq.filter.MessageEvaluationContext;
import org.activemq.filter.PrefixDestinationFilter;
import org.activemq.filter.SimpleDestinationFilter;
import org.activemq.filter.WildcardDestinationFilter;
import org.activemq.util.JMSExceptionSupport;

public abstract class DestinationFilter
implements BooleanExpression {
    public static final String ANY_DESCENDENT = ">";
    public static final String ANY_CHILD = "*";

    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean matches(MessageEvaluationContext message) throws JMSException {
        try {
            if (message.isDropped()) {
                return false;
            }
            return this.matches(message.getMessage().getOriginalDestination());
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public abstract boolean matches(ActiveMQDestination var1);

    public static DestinationFilter parseFilter(ActiveMQDestination destination) {
        if (destination.isComposite()) {
            return new CompositeDestinationFilter(destination);
        }
        String[] paths = DestinationPath.getDestinationPaths(destination);
        int idx = paths.length - 1;
        if (idx >= 0) {
            String lastPath = paths[idx];
            if (lastPath.equals(ANY_DESCENDENT)) {
                return new PrefixDestinationFilter(paths);
            }
            while (idx >= 0) {
                if (!(lastPath = paths[idx--]).equals(ANY_CHILD)) continue;
                return new WildcardDestinationFilter(paths);
            }
        }
        return new SimpleDestinationFilter(destination);
    }
}

