/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.memory.list;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.memory.list.MessageList;

public class SimpleMessageList
implements MessageList {
    private LinkedList list = new LinkedList();
    private int maximumSize = 0x640000;
    private int size;
    private Object lock = new Object();

    public SimpleMessageList() {
    }

    public SimpleMessageList(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageReference node) {
        int delta = node.getMessageHardRef().getSize();
        Object object = this.lock;
        synchronized (object) {
            this.list.add(node);
            this.size += delta;
            while (this.size > this.maximumSize) {
                MessageReference evicted = (MessageReference)this.list.removeFirst();
                this.size -= evicted.getMessageHardRef().getSize();
            }
        }
    }

    public List getMessages(Subscription sub) {
        return this.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.list.clear();
            this.size = 0;
        }
    }
}

