/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ConsumerId;
import org.activemq.command.DataStructure;
import org.activemq.command.Message;
import org.activemq.command.MessageDispatch;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class MessageDispatchMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 21;
    }

    public DataStructure createObject() {
        return new MessageDispatch();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        MessageDispatch info = (MessageDispatch)o;
        info.setConsumerId((ConsumerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setMessage((Message)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setRedeliveryCounter(dataIn.readInt());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageDispatch info = (MessageDispatch)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getConsumerId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getDestination(), bs);
        return (rc += this.marshal1NestedObject(wireFormat, info.getMessage(), bs)) + 4;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        MessageDispatch info = (MessageDispatch)o;
        this.marshal2CachedObject(wireFormat, info.getConsumerId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getDestination(), dataOut, bs);
        this.marshal2NestedObject(wireFormat, info.getMessage(), dataOut, bs);
        dataOut.writeInt(info.getRedeliveryCounter());
    }
}

