/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionContext {
    private static final Log log = LogFactory.getLog((Class)TransactionContext.class);
    private final DataSource dataSource;
    private Connection connection;
    private boolean inTx;
    private PreparedStatement addMessageStatement;
    private PreparedStatement removedMessageStatement;
    private PreparedStatement updateLastAckStatement;

    public TransactionContext(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws IOException {
        if (this.connection == null) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(!this.inTx);
            }
            catch (SQLException e) {
                throw IOExceptionSupport.create(e);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException {
        try {
            this.executeBatch(this.addMessageStatement, "Failed add a message");
        }
        finally {
            this.addMessageStatement = null;
            try {
                this.executeBatch(this.removedMessageStatement, "Failed to remove a message");
            }
            finally {
                this.removedMessageStatement = null;
                try {
                    this.executeBatch(this.updateLastAckStatement, "Failed to ack a message");
                }
                finally {
                    this.updateLastAckStatement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(PreparedStatement p, String message) throws SQLException {
        if (p == null) {
            return;
        }
        try {
            int[] rc = p.executeBatch();
            for (int i = 0; i < rc.length; ++i) {
                if (rc[i] == 1) continue;
                throw new SQLException(message);
            }
        }
        finally {
            try {
                p.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.inTx) return;
        try {
            try {
                this.executeBatch();
                return;
            }
            finally {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create(e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (Throwable e) {
                log.warn((Object)("Close failed: " + e.getMessage()), e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void begin() throws IOException {
        if (this.inTx) {
            throw new IOException("Already started.");
        }
        this.inTx = true;
        this.connection = this.getConnection();
    }

    public void commit() throws IOException {
        if (!this.inTx) {
            throw new IOException("Not started.");
        }
        try {
            this.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            log.info((Object)("commit failed: " + e.getMessage()), (Throwable)e);
            throw IOExceptionSupport.create(e);
        }
        finally {
            this.inTx = false;
            this.close();
        }
    }

    public void rollback() throws IOException {
        if (!this.inTx) {
            throw new IOException("Not started.");
        }
        try {
            if (this.addMessageStatement != null) {
                this.addMessageStatement.close();
                this.addMessageStatement = null;
            }
            if (this.removedMessageStatement != null) {
                this.removedMessageStatement.close();
                this.removedMessageStatement = null;
            }
            if (this.updateLastAckStatement != null) {
                this.updateLastAckStatement.close();
                this.updateLastAckStatement = null;
            }
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create(e);
        }
        finally {
            this.inTx = false;
            this.close();
        }
    }

    public PreparedStatement getAddMessageStatement() {
        return this.addMessageStatement;
    }

    public void setAddMessageStatement(PreparedStatement addMessageStatement) {
        this.addMessageStatement = addMessageStatement;
    }

    public PreparedStatement getUpdateLastAckStatement() {
        return this.updateLastAckStatement;
    }

    public void setUpdateLastAckStatement(PreparedStatement ackMessageStatement) {
        this.updateLastAckStatement = ackMessageStatement;
    }

    public PreparedStatement getRemovedMessageStatement() {
        return this.removedMessageStatement;
    }

    public void setRemovedMessageStatement(PreparedStatement removedMessageStatement) {
        this.removedMessageStatement = removedMessageStatement;
    }
}

