/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc.adapter;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.MessageId;
import org.activemq.command.SubscriptionInfo;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.activemq.store.jdbc.StatementProvider;
import org.activemq.store.jdbc.TransactionContext;
import org.activemq.store.jdbc.adapter.CachingStatementProvider;
import org.activemq.store.jdbc.adapter.DefaultStatementProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Log log = LogFactory.getLog((Class)DefaultJDBCAdapter.class);
    protected final StatementProvider statementProvider;
    protected boolean batchStatments = true;

    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBytes(index, data);
    }

    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }

    public DefaultJDBCAdapter(StatementProvider provider) {
        this.statementProvider = new CachingStatementProvider(provider);
    }

    public DefaultJDBCAdapter() {
        this(new DefaultStatementProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        try {
            log.info((Object)"creating tables");
            s = c.getConnection().createStatement();
            String[] createStatments = this.statementProvider.getCreateSchemaStatments();
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    boolean rc = s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.warn((Object)("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                }
            }
            c.getConnection().commit();
            log.info((Object)"done creating tables");
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDropTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        try {
            s = c.getConnection().createStatement();
            String[] dropStatments = this.statementProvider.getDropSchemaStatments();
            for (int i = 0; i < dropStatments.length; ++i) {
                try {
                    boolean rc = s.execute(dropStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.warn((Object)("Could not drop JDBC tables; they may not exist. Failure was: " + dropStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                }
            }
            c.getConnection().commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doGetLastMessageBrokerSequenceId(TransactionContext c) throws SQLException, IOException {
        long l;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getFindLastSequenceIdInMsgs());
            rs = s.executeQuery();
            long seq1 = 0L;
            if (rs.next()) {
                seq1 = rs.getLong(1);
            }
            rs.close();
            s.close();
            s = c.getConnection().prepareStatement(this.statementProvider.getFindLastSequenceIdInAcks());
            rs = s.executeQuery();
            long seq2 = 0L;
            if (rs.next()) {
                seq2 = rs.getLong(1);
            }
            l = Math.max(seq1, seq2);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddMessage(TransactionContext c, MessageId messageID, ActiveMQDestination destination, byte[] data, long expiration) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statementProvider.getAddMessageStatment());
                if (this.batchStatments) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, messageID.getBrokerSequenceId());
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expiration);
            this.setBinaryData(s, 6, data);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBrokerSequenceId(TransactionContext c, MessageId messageID) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            long l;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statementProvider.getFindMessageSequenceIdStatment());
                s.setString(1, messageID.getProducerId().toString());
                s.setLong(2, messageID.getProducerSequenceId());
                rs = s.executeQuery();
                if (rs.next()) break block3;
                l = 0L;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return l;
        }
        long l = rs.getLong(1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doGetMessage(TransactionContext c, long seq) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statementProvider.getFindMessageStatment());
                s.setLong(1, seq);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveMessage(TransactionContext c, long seq) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statementProvider.getRemoveMessageStatment());
                if (this.batchStatments) {
                    c.setRemovedMessageStatement(s);
                }
            }
            s.setLong(1, seq);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to remove message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecover(TransactionContext c, ActiveMQDestination destination, JDBCMessageRecoveryListener listener) throws Throwable {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getFindAllMessagesStatment());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            while (rs.next()) {
                listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetLastAck(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statementProvider.getUpdateLastAckOfDurableSub());
                if (this.batchStatments) {
                    c.setUpdateLastAckStatement(s);
                }
            }
            s.setLong(1, seq);
            s.setString(2, destination.getQualifiedName());
            s.setString(3, clientId);
            s.setString(4, subscriptionName);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecoverSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, JDBCMessageRecoveryListener listener) throws Throwable {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getFindAllDurableSubMessagesStatment());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            rs = s.executeQuery();
            while (rs.next()) {
                listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2));
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetSubscriberEntry(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, String selector, boolean retroactive) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            long lastMessageId = -1L;
            if (!retroactive) {
                s = c.getConnection().prepareStatement(this.statementProvider.getFindLastSequenceIdInMsgs());
                ResultSet rs = null;
                try {
                    rs = s.executeQuery();
                    if (rs.next()) {
                        lastMessageId = rs.getLong(1);
                    }
                }
                finally {
                    DefaultJDBCAdapter.close(rs);
                    DefaultJDBCAdapter.close(s);
                }
            }
            s = c.getConnection().prepareStatement(this.statementProvider.getCreateDurableSubStatment());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.setString(4, selector);
            s.setLong(5, lastMessageId);
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not create durable subscription for: " + clientId);
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionInfo doGetSubscriberEntry(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            SubscriptionInfo subscriptionInfo;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statementProvider.getFindDurableSubStatment());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriptionName);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                subscriptionInfo = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return subscriptionInfo;
        }
        SubscriptionInfo subscription = new SubscriptionInfo();
        subscription.setDestination(destination);
        subscription.setClientId(clientId);
        subscription.setSubcriptionName(subscriptionName);
        subscription.setSelector(rs.getString(1));
        SubscriptionInfo subscriptionInfo = subscription;
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveAllMessages(TransactionContext c, ActiveMQDestination destinationName) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getRemoveAllMessagesStatment());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
            s.close();
            s = c.getConnection().prepareStatement(this.statementProvider.getRemoveAllSubscriptionsStatment());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getDeleteSubscriptionStatment());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.executeUpdate();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteOldMessages(TransactionContext c) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getDeleteOldMessagesStatment());
            s.setLong(1, System.currentTimeMillis());
            int i = s.executeUpdate();
            log.debug((Object)("Deleted " + i + " old message(s)."));
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    private static void close(PreparedStatement s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set doGetDestinations(TransactionContext c) throws SQLException, IOException {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statementProvider.getFindAllDestinationsStatment());
            rs = s.executeQuery();
            while (rs.next()) {
                rc.add(ActiveMQDestination.createDestination(rs.getString(1), (byte)1));
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return rc;
    }

    public boolean isBatchStatments() {
        return this.batchStatments;
    }

    public void setBatchStatments(boolean batchStatments) {
        this.batchStatments = batchStatments;
    }
}

