/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import org.activemq.command.KeepAliveInfo;
import org.activemq.management.CountStatisticImpl;
import org.activemq.thread.Scheduler;
import org.activemq.transport.InactivityIOException;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFilter;

public class InactivityMonitor
extends TransportFilter
implements Runnable {
    private final long maxInactivityDuration;
    private final AtomicBoolean cancled = new AtomicBoolean(false);
    private byte runIteration = 0;
    private long lastReadCount;
    private long lastWriteCount;
    private final CountStatisticImpl readCounter;
    private final CountStatisticImpl writeCounter;

    public InactivityMonitor(Transport next, long maxInactivityDuration, CountStatisticImpl readCounter, CountStatisticImpl writeCounter) {
        super(next);
        this.maxInactivityDuration = maxInactivityDuration;
        this.readCounter = readCounter;
        this.writeCounter = writeCounter;
    }

    public void start() throws Exception {
        this.next.start();
        Scheduler.executePeriodically(this, this.maxInactivityDuration / 5L);
    }

    public void stop() throws Exception {
        if (this.cancled.compareAndSet(false, true)) {
            Scheduler.cancel(this);
        }
        this.next.stop();
    }

    public void run() {
        switch (this.runIteration) {
            case 1: 
            case 2: {
                long wc = this.writeCounter.getCount();
                if (wc == this.lastWriteCount) {
                    try {
                        this.oneway(new KeepAliveInfo());
                    }
                    catch (IOException e) {
                        this.onException(e);
                    }
                    break;
                }
                this.lastWriteCount = wc;
                break;
            }
            case 4: {
                long rc = this.readCounter.getCount();
                if (rc == this.lastReadCount) {
                    this.onException(new InactivityIOException("Channel was inactive for too long."));
                    break;
                }
                this.lastReadCount = rc;
            }
        }
        this.runIteration = (byte)(this.runIteration + 1);
        if (this.runIteration >= 5) {
            this.runIteration = 0;
        }
    }

    public void onException(IOException error) {
        if (this.cancled.compareAndSet(false, true)) {
            Scheduler.cancel(this);
        }
        this.commandListener.onException(error);
    }
}

