/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.activemq.broker.BrokerFactory;
import org.activemq.broker.BrokerRegistry;
import org.activemq.broker.BrokerService;
import org.activemq.broker.TransportConnector;
import org.activemq.transport.MarshallingTransportFilter;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.activemq.transport.vm.VMTransport;
import org.activemq.transport.vm.VMTransportServer;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.ServiceSupport;
import org.activemq.util.URISupport;

public class VMTransportFactory
extends TransportFactory {
    public static final ConcurrentHashMap brokers = new ConcurrentHashMap();
    public static final ConcurrentHashMap connectors = new ConcurrentHashMap();
    public static final ConcurrentHashMap servers = new ConcurrentHashMap();

    public Transport doConnect(URI location) throws Exception {
        return VMTransportServer.configure(this.doCompositeConnect(location));
    }

    public Transport doCompositeConnect(URI location) throws Exception {
        Map options;
        String host;
        URI brokerURI;
        if (location.getSchemeSpecificPart().startsWith("broker:")) {
            brokerURI = new URI(location.getSchemeSpecificPart());
            URISupport.CompositeData data = URISupport.parseComposite(brokerURI);
            host = (String)data.getParameters().get("brokerName");
            if (host == null) {
                host = "localhost";
            }
            options = IntrospectionSupport.extractProperties(data.getParameters(), "transport.");
            location = new URI("vm://" + host);
        } else {
            try {
                host = location.getHost();
                options = URISupport.parseParamters(location);
                Map brokerOptions = IntrospectionSupport.extractProperties(options, "broker.");
                brokerURI = URISupport.createRemainingURI(location, brokerOptions);
                brokerURI = URISupport.changeScheme(brokerURI, "broker");
            }
            catch (URISyntaxException e1) {
                throw IOExceptionSupport.create(e1);
            }
            location = new URI("vm://" + host);
        }
        VMTransportServer server = (VMTransportServer)servers.get((Object)host);
        if (server == null) {
            BrokerService broker = BrokerRegistry.getInstance().lookup(host);
            if (broker == null) {
                try {
                    broker = BrokerFactory.createBroker(brokerURI);
                }
                catch (URISyntaxException e) {
                    throw IOExceptionSupport.create(e);
                }
                brokers.put((Object)host, (Object)broker);
            }
            if ((server = (VMTransportServer)servers.get((Object)host)) == null) {
                server = (VMTransportServer)this.bind(location, true);
                TransportConnector connector = new TransportConnector(broker.getBroker(), server);
                connector.start();
                connectors.put((Object)host, (Object)connector);
            }
        }
        VMTransport vmtransport = server.connect();
        IntrospectionSupport.setProperties(vmtransport, options);
        Transport transport = vmtransport;
        if (vmtransport.isMarshal()) {
            transport = new MarshallingTransportFilter(transport, this.createWireFormat(options), this.createWireFormat(options));
        }
        if (!options.isEmpty()) {
            throw new IllegalArgumentException("Invalid connect parameters: " + options);
        }
        return transport;
    }

    public TransportServer doBind(URI location) throws IOException {
        return this.bind(location, false);
    }

    private TransportServer bind(URI location, boolean dispose) throws IOException {
        String host = location.getHost();
        VMTransportServer server = new VMTransportServer(location, dispose);
        Object currentBoundValue = servers.get((Object)host);
        if (currentBoundValue != null) {
            throw new IOException("VMTransportServer already bound at: " + location);
        }
        servers.put((Object)host, (Object)server);
        return server;
    }

    public static void stopped(VMTransportServer server) {
        String host = server.getBindURI().getHost();
        servers.remove((Object)host);
        TransportConnector connector = (TransportConnector)connectors.remove((Object)host);
        if (connector != null) {
            ServiceSupport.dispose(connector);
            BrokerService broker = (BrokerService)brokers.remove((Object)host);
            if (broker != null) {
                ServiceSupport.dispose(broker);
            }
        }
    }
}

