/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import junit.framework.Assert;

public class MessageList
extends Assert
implements MessageListener {
    private List messages = new ArrayList();
    private Object semaphore;
    private boolean verbose;

    public MessageList() {
        this(new Object());
    }

    public MessageList(Object semaphore) {
        this.semaphore = semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List flushMessages() {
        Object object = this.semaphore;
        synchronized (object) {
            ArrayList answer = new ArrayList(this.messages);
            this.messages.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getMessages() {
        Object object = this.semaphore;
        synchronized (object) {
            return new ArrayList(this.messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Object object = this.semaphore;
        synchronized (object) {
            this.messages.add(message);
            this.semaphore.notifyAll();
        }
        if (this.verbose) {
            System.out.println("###\u00a0received message: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.semaphore;
        synchronized (object) {
            return this.messages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount) {
        System.out.println("Waiting for message to arrive");
        long start = System.currentTimeMillis();
        for (int i = 0; i < messageCount; ++i) {
            try {
                if (this.hasReceivedMessages(messageCount)) break;
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(4000L);
                    continue;
                }
            }
            catch (InterruptedException e) {
                System.out.println("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("End of wait for " + end + " millis");
    }

    public void assertMessagesReceived(int messageCount) {
        this.waitForMessagesToArrive(messageCount);
        MessageList.assertEquals((String)("expected number of messages when received: " + this.getMessages()), (int)messageCount, (int)this.getMessageCount());
    }

    public boolean hasReceivedMessage() {
        return this.getMessageCount() == 0;
    }

    public boolean hasReceivedMessages(int messageCount) {
        return this.getMessageCount() >= messageCount;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

