/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.ember;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.transport.TransportChannelSupport;
import pyrasun.eio.EIOGlobalContext;
import pyrasun.eio.services.EmberServiceController;
import pyrasun.eio.services.EmberServiceException;
import pyrasun.eio.services.bytearray.ByteArrayServerClient;
import pyrasun.eio.services.bytearray.ByteArrayServerClientListener;

public class EmberTransportChannel
extends TransportChannelSupport
implements ByteArrayServerClientListener {
    private static final Log log = LogFactory.getLog((Class)EmberTransportChannel.class);
    private WireFormat wireFormat;
    private EIOGlobalContext context;
    private EmberServiceController controller;
    private ByteArrayServerClient client;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;

    protected EmberTransportChannel(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
    }

    public EmberTransportChannel(WireFormat wireFormat, EIOGlobalContext context, EmberServiceController controller, ByteArrayServerClient client) {
        this(wireFormat);
        this.context = context;
        this.client = client;
        this.controller = controller;
        client.setListener((ByteArrayServerClientListener)this);
    }

    public void stop() {
        super.stop();
        if (this.closed.commit(false, true)) {
            try {
                if (this.controller != null) {
                    this.controller.stopAll();
                }
                if (this.context != null) {
                    this.context.stop();
                }
            }
            catch (EmberServiceException e) {
                log.error((Object)("Caught while closing: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void forceDisconnect() {
        throw new RuntimeException("Not yet Implemented.");
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            try {
                if (this.context != null) {
                    this.context.start();
                }
                if (this.controller != null) {
                    this.controller.startAll();
                }
            }
            catch (EmberServiceException e) {
                JMSException jmsEx = new JMSException("Error starting NIO client: " + e.getMessage());
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncSend(Packet packet) throws JMSException {
        try {
            byte[] bytes = this.wireFormat.toBytes(packet);
            ByteArrayServerClient byteArrayServerClient = this.client;
            synchronized (byteArrayServerClient) {
                this.client.write((Object)bytes);
            }
        }
        catch (IOException e) {
            throw this.createJMSException("Failed to write packet: " + packet + ". ", e);
        }
    }

    public boolean isMulticast() {
        return false;
    }

    protected JMSException createJMSException(String message, Exception ex) {
        JMSException jmsEx = new JMSException(message + ex.getMessage());
        jmsEx.setLinkedException(ex);
        return jmsEx;
    }

    public String toString() {
        return "EmberTransportChannel: " + this.client;
    }

    public void newMessage(ByteArrayServerClient client, Object msg) {
        byte[] bytes = (byte[])msg;
        Packet packet = null;
        try {
            packet = this.wireFormat.fromBytes(bytes);
            this.doConsumePacket(packet);
        }
        catch (IOException e) {
            log.error((Object)("Could not parse byte[] of size: " + bytes.length + ". Reason: " + e), (Throwable)e);
        }
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.wireFormat.canProcessWireFormatVersion(version);
    }

    public int getCurrentWireFormatVersion() {
        return this.wireFormat.getCurrentWireFormatVersion();
    }
}

