/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CollectiveBcastRecvV2", inputsClass=Inputs.class)
public final class CollectiveBcastRecv<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "CollectiveBcastRecvV2";
    private Output<U> data;

    public CollectiveBcastRecv(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static <U extends TType> CollectiveBcastRecv<U> create(Scope scope, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Operand<? extends TNumber> shape, Class<U> T, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CollectiveBcastRecv");
        opBuilder.addInput(groupSize.asOutput());
        opBuilder.addInput(groupKey.asOutput());
        opBuilder.addInput(instanceKey.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.setAttr("T", Operands.toDataType(T));
        if (options != null) {
            for (Options opts : options) {
                if (opts.communicationHint != null) {
                    opBuilder.setAttr("communication_hint", opts.communicationHint);
                }
                if (opts.timeoutSeconds == null) continue;
                opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
            }
        }
        return new CollectiveBcastRecv<U>(opBuilder.build());
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public Output<U> data() {
        return this.data;
    }

    @Override
    public Output<U> asOutput() {
        return this.data;
    }

    @OpInputsMetadata(outputsClass=CollectiveBcastRecv.class)
    public static class Inputs
    extends RawOpInputs<CollectiveBcastRecv<?>> {
        public final Operand<TInt32> groupSize;
        public final Operand<TInt32> groupKey;
        public final Operand<TInt32> instanceKey;
        public final Operand<? extends TNumber> shape;
        public final DataType T;
        public final DataType Tshape;
        public final String communicationHint;
        public final float timeoutSeconds;

        public Inputs(GraphOperation op) {
            super(new CollectiveBcastRecv(op), op, Arrays.asList("T", "Tshape", "communication_hint", "timeout_seconds"));
            int inputIndex = 0;
            this.groupSize = op.input(inputIndex++);
            this.groupKey = op.input(inputIndex++);
            this.instanceKey = op.input(inputIndex++);
            this.shape = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tshape = op.attributes().getAttrType("Tshape");
            this.communicationHint = op.attributes().getAttrString("communication_hint");
            this.timeoutSeconds = op.attributes().getAttrFloat("timeout_seconds");
        }
    }

    public static class Options {
        private String communicationHint;
        private Float timeoutSeconds;

        private Options() {
        }

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }
    }
}

