/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseCoreAdagradMomentum", inputsClass=Inputs.class)
public final class XlaSparseCoreAdagradMomentum
extends RawOp {
    public static final String OP_NAME = "XlaSparseCoreAdagradMomentum";
    private Output<TFloat32> updatedEmbeddingTable;
    private Output<TFloat32> updatedAccumulator;
    private Output<TFloat32> updatedMomentum;

    public XlaSparseCoreAdagradMomentum(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
        this.updatedAccumulator = operation.output(outputIdx++);
        this.updatedMomentum = operation.output(outputIdx++);
    }

    public static XlaSparseCoreAdagradMomentum create(Scope scope, Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> beta1, Operand<TFloat32> epsilon, Operand<TFloat32> accumulator, Operand<TFloat32> momentum, Operand<TFloat32> embeddingTable, Long featureWidth, Boolean useNesterov, Float beta2, Float exponent) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(gradient.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(beta1.asOutput());
        opBuilder.addInput(epsilon.asOutput());
        opBuilder.addInput(accumulator.asOutput());
        opBuilder.addInput(momentum.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.setAttr("feature_width", featureWidth);
        opBuilder.setAttr("use_nesterov", useNesterov);
        opBuilder.setAttr("beta_2", beta2.floatValue());
        opBuilder.setAttr("exponent", exponent.floatValue());
        return new XlaSparseCoreAdagradMomentum(opBuilder.build());
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    public Output<TFloat32> updatedAccumulator() {
        return this.updatedAccumulator;
    }

    public Output<TFloat32> updatedMomentum() {
        return this.updatedMomentum;
    }

    @OpInputsMetadata(outputsClass=XlaSparseCoreAdagradMomentum.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseCoreAdagradMomentum> {
        public final Operand<TInt32> indices;
        public final Operand<TFloat32> gradient;
        public final Operand<TFloat32> learningRate;
        public final Operand<TFloat32> beta1;
        public final Operand<TFloat32> epsilon;
        public final Operand<TFloat32> accumulator;
        public final Operand<TFloat32> momentum;
        public final Operand<TFloat32> embeddingTable;
        public final long featureWidth;
        public final boolean useNesterov;
        public final float beta2;
        public final float exponent;

        public Inputs(GraphOperation op) {
            super(new XlaSparseCoreAdagradMomentum(op), op, Arrays.asList("feature_width", "use_nesterov", "beta_2", "exponent"));
            int inputIndex = 0;
            this.indices = op.input(inputIndex++);
            this.gradient = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.beta1 = op.input(inputIndex++);
            this.epsilon = op.input(inputIndex++);
            this.accumulator = op.input(inputIndex++);
            this.momentum = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.featureWidth = op.attributes().getAttrInt("feature_width");
            this.useNesterov = op.attributes().getAttrBool("use_nesterov");
            this.beta2 = op.attributes().getAttrFloat("beta_2");
            this.exponent = op.attributes().getAttrFloat("exponent");
        }
    }
}

