/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnSet;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.Table;

public class VersionGenerator {
    private List tablesByOrder = new ArrayList();
    private Map tablesByName = new HashMap();
    private Set propertyNames = new HashSet();
    private boolean generatingLogging;
    static /* synthetic */ Class class$java$lang$IllegalStateException;
    static /* synthetic */ Class class$org$apache$ws$jaxme$logging$Logger;
    static /* synthetic */ Class class$org$apache$ws$jaxme$logging$LoggerAccess;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$sql$Types;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$sql$SQLException;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;

    private boolean isReferencing(Table pReferencingTable, Table pReferencedTable) {
        Iterator iter = pReferencingTable.getForeignKeys();
        while (iter.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iter.next();
            if (!foreignKey.getReferencedTable().equals(pReferencedTable)) continue;
            return true;
        }
        return false;
    }

    public boolean isGeneratingLogging() {
        return this.generatingLogging;
    }

    public void setGeneratingLogging(boolean pGeneratingLogging) {
        this.generatingLogging = pGeneratingLogging;
    }

    protected void initLogging(JavaSource pSource) {
        if (this.isGeneratingLogging()) {
            JavaField jf = pSource.newJavaField("logger", class$org$apache$ws$jaxme$logging$Logger == null ? (class$org$apache$ws$jaxme$logging$Logger = VersionGenerator.class$("org.apache.ws.jaxme.logging.Logger")) : class$org$apache$ws$jaxme$logging$Logger, JavaSource.PRIVATE);
            jf.setFinal(true);
            jf.setStatic(true);
            jf.addLine(class$org$apache$ws$jaxme$logging$LoggerAccess == null ? (class$org$apache$ws$jaxme$logging$LoggerAccess = VersionGenerator.class$("org.apache.ws.jaxme.logging.LoggerAccess")) : class$org$apache$ws$jaxme$logging$LoggerAccess, ".getLogger(", pSource.getQName(), ".class)");
        }
    }

    protected void logEntering(JavaMethod pMethod, Object pValues) {
        if (this.isGeneratingLogging()) {
            LocalJavaField mName = pMethod.newJavaField(class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, "mName");
            mName.addLine(JavaSource.getQuoted(pMethod.getLoggingSignature()));
            mName.setFinal(true);
            if (pValues == null) {
                pMethod.addLine("logger.entering(", mName, ");");
            } else {
                pMethod.addLine("logger.entering(", mName, ", ", pValues, ");");
            }
        }
    }

    protected void logFinestEntering(JavaMethod pMethod, Object pValues) {
        if (this.isGeneratingLogging()) {
            LocalJavaField mName = pMethod.newJavaField(class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, "mName");
            mName.addLine(JavaSource.getQuoted(pMethod.getLoggingSignature()));
            mName.setFinal(true);
            this.logFinest(pMethod, JavaSource.getQuoted("->"), pValues);
        }
    }

    protected void logExiting(JavaMethod pMethod, Object pValues) {
        if (this.isGeneratingLogging()) {
            if (pValues == null) {
                pMethod.addLine("logger.exiting(mName);");
            } else {
                pMethod.addLine("logger.exiting(mName, ", pValues, ");");
            }
        }
    }

    protected void logFinestExiting(JavaMethod pMethod, Object pValues) {
        this.logFinest(pMethod, JavaSource.getQuoted("->"), pValues);
    }

    protected void logFinest(JavaMethod pMethod, Object pMsg, Object pValues) {
        if (this.isGeneratingLogging()) {
            if (pValues == null) {
                pMethod.addLine("logger.finest(mName, ", pMsg, ");");
            } else {
                pMethod.addLine("logger.finest(mName, ", pMsg, ", ", pValues, ");");
            }
        }
    }

    public void addTable(Table pTable, ColumnUpdater pUpdater) {
        String s;
        String name = pTable.getQName();
        if (this.tablesByName.containsKey(pTable)) {
            throw new IllegalStateException("A table " + name + " has already been added.");
        }
        if (this.isReferencing(pTable, pTable)) {
            throw new IllegalStateException("The table " + name + " is containing self references.");
        }
        Iterator iter = this.tablesByOrder.iterator();
        while (iter.hasNext()) {
            TableInfo tableInfo = (TableInfo)iter.next();
            if (!this.isReferencing(tableInfo.getTable(), pTable)) continue;
            throw new IllegalStateException("The table " + tableInfo.getTable().getQName() + " contains a forward reference to the table " + name + ".");
        }
        String t = s = pTable.getName().getName();
        int num = 0;
        while (this.propertyNames.contains(t = Character.toUpperCase(t.charAt(0)) + t.substring(1))) {
            t = s + num++;
        }
        this.propertyNames.add(t);
        TableInfo tableInfo = new TableInfo(pTable, t);
        tableInfo.setPrimaryKey(pTable.getPrimaryKey() != null);
        if (pUpdater != null) {
            tableInfo.add(pUpdater);
        }
        Iterator iter2 = pTable.getForeignKeys();
        while (iter2.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iter2.next();
            Table referencedTable = foreignKey.getReferencedTable();
            Iterator iter22 = this.tablesByOrder.iterator();
            while (iter22.hasNext()) {
                TableInfo referencedTableInfo = (TableInfo)iter22.next();
                if (!referencedTableInfo.getTable().equals(referencedTable)) continue;
                ForeignKeyUpdater columnUpdater = new ForeignKeyUpdater(foreignKey, referencedTableInfo);
                tableInfo.add(columnUpdater);
                if (!referencedTableInfo.hasPrimaryKey()) {
                    throw new IllegalStateException("The table " + pTable.getQName() + " is referencing table " + referencedTable.getQName() + ", which doesn't have a primary key.");
                }
                referencedTableInfo.setReferenced(true);
            }
        }
        this.tablesByName.put(name, tableInfo);
        this.tablesByOrder.add(tableInfo);
    }

    protected JavaQName getCacheDataClassName(JavaQName pQName) {
        return JavaQNameImpl.getInnerInstance(pQName, "CacheData");
    }

    protected JavaInnerClass getCacheDataClass(JavaSource pSource) {
        JavaInnerClass jic = pSource.newJavaInnerClass("CacheData", JavaSource.PRIVATE);
        JavaField name = jic.newJavaField("name", class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PRIVATE);
        name.setFinal(true);
        JavaField values = jic.newJavaField("values", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, JavaSource.PRIVATE);
        values.setFinal(true);
        JavaConstructor jcon = jic.newJavaConstructor(JavaSource.PRIVATE);
        Parameter pName = jcon.addParam(class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, "pName");
        Parameter pValues = jcon.addParam(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "pValues");
        jcon.addLine(name, " = ", pName, ";");
        jcon.addLine(values, " = ", pValues, ";");
        JavaMethod getNameMethod = jic.newJavaMethod("getName", class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PUBLIC);
        getNameMethod.addLine("return ", name, ";");
        JavaMethod getValuesMethod = jic.newJavaMethod("getValues", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, JavaSource.PUBLIC);
        getValuesMethod.addLine("return ", values, ";");
        JavaMethod jm = jic.newJavaMethod("toString", class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PUBLIC);
        LocalJavaField sb = jm.newJavaField(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = VersionGenerator.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer, "sb");
        sb.addLine("new ", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = VersionGenerator.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer, "(", name, ")");
        DirectAccessible loopVar = jm.addForArray(values);
        jm.addLine(sb, ".append(", JavaSource.getQuoted(", "), ").append(", values, "[", loopVar, "]);");
        jm.addEndFor();
        jm.addLine("return ", sb, ".toString();");
        jm = jic.newJavaMethod("hashCode", Integer.TYPE, JavaSource.PUBLIC);
        LocalJavaField hashCodeResult = jm.newJavaField(Integer.TYPE, "result");
        hashCodeResult.addLine(name, ".hashCode() + ", values, ".length;");
        loopVar = jm.addForArray(values);
        LocalJavaField o = jm.newJavaField(class$java$lang$Object == null ? (class$java$lang$Object = VersionGenerator.class$("java.lang.Object")) : class$java$lang$Object, "o");
        o.addLine(values, "[", loopVar, "]");
        jm.addIf(o, (Object)" != null");
        jm.addLine(hashCodeResult, " += ", o, ".hashCode();");
        jm.addEndIf();
        jm.addEndFor();
        jm.addLine("return ", hashCodeResult, ";");
        jm = jic.newJavaMethod("equals", Boolean.TYPE, JavaSource.PUBLIC);
        Parameter o2 = jm.addParam(class$java$lang$Object == null ? (class$java$lang$Object = VersionGenerator.class$("java.lang.Object")) : class$java$lang$Object, "o");
        jm.addIf(o2, (Object)" == null  ||  !(", (Object)o2, (Object)" instanceof ", (Object)jic.getQName(), (Object)")");
        jm.addLine("return false;");
        jm.addEndIf();
        LocalJavaField other = jm.newJavaField(jic.getQName(), "other");
        other.addLine("(", jic.getQName(), ") ", o2);
        jm.addIf("!", (Object)name, (Object)".equals(", (Object)other, (Object)".name)  ||  ", (Object)values, (Object)".length != ", (Object)other, (Object)".values.length");
        jm.addLine("return false;");
        jm.addEndIf();
        DirectAccessible loopVar2 = jm.addForArray(values);
        LocalJavaField v = jm.newJavaField(class$java$lang$Object == null ? (class$java$lang$Object = VersionGenerator.class$("java.lang.Object")) : class$java$lang$Object, "v");
        v.addLine(values, "[", loopVar2, "]");
        jm.addIf(v, (Object)" == null");
        jm.addIf(other, (Object)".values[", (Object)loopVar2, (Object)"] != null");
        jm.addLine("return false;");
        jm.addEndIf();
        jm.addElse();
        jm.addIf("!", (Object)v, (Object)".equals(", (Object)other, (Object)".values[", (Object)loopVar2, (Object)"])");
        jm.addLine("return false;");
        jm.addEndIf();
        jm.addEndIf();
        jm.addEndFor();
        jm.addLine("return true;");
        return jic;
    }

    protected void setResultSetValue(JavaMethod pMethod, Column pColumn, DirectAccessible pResultSet, int pColumnNum, Object pTarget) {
        Integer p = new Integer(pColumnNum + 1);
        Column.Type type = pColumn.getType();
        if (Column.Type.BIGINT.equals(type)) {
            LocalJavaField l = pMethod.newJavaField(Long.TYPE);
            l.addLine(pResultSet, ".getLong(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = new ", class$java$lang$Long == null ? (class$java$lang$Long = VersionGenerator.class$("java.lang.Long")) : class$java$lang$Long, "(", l, ");");
            pMethod.addEndIf();
        } else if (pColumn.isBinaryColumn()) {
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = ", pResultSet, ".getBytes(", p, ");");
        } else if (Column.Type.BIT.equals(type)) {
            LocalJavaField b = pMethod.newJavaField(Boolean.TYPE);
            b.addLine(pResultSet, ".getBoolean(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = ", b, " ? ", class$java$lang$Boolean == null ? (class$java$lang$Boolean = VersionGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean, ".TRUE : ", class$java$lang$Boolean == null ? (class$java$lang$Boolean = VersionGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean, ".FALSE;");
            pMethod.addEndIf();
        } else if (pColumn.isStringColumn()) {
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = ", pResultSet, ".getString(", p, ");");
        } else if (Column.Type.DATE.equals(type)) {
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = ", pResultSet, ".getDate(", p, ");");
        } else if (Column.Type.DOUBLE.equals(type)) {
            LocalJavaField d = pMethod.newJavaField(Double.TYPE);
            d.addLine(pResultSet, ".getDouble(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = new ", class$java$lang$Double == null ? (class$java$lang$Double = VersionGenerator.class$("java.lang.Double")) : class$java$lang$Double, "(", d, ");");
            pMethod.addEndIf();
        } else if (Column.Type.FLOAT.equals(type)) {
            LocalJavaField f = pMethod.newJavaField(Float.TYPE);
            f.addLine(pResultSet, ".getFloat(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = new ", class$java$lang$Float == null ? (class$java$lang$Float = VersionGenerator.class$("java.lang.Float")) : class$java$lang$Float, "(", f, ");");
            pMethod.addEndIf();
        } else if (Column.Type.INTEGER.equals(type)) {
            LocalJavaField i = pMethod.newJavaField(Integer.TYPE);
            i.addLine(pResultSet, ".getInt(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = new ", class$java$lang$Integer == null ? (class$java$lang$Integer = VersionGenerator.class$("java.lang.Integer")) : class$java$lang$Integer, "(", i, ");");
            pMethod.addEndIf();
        } else if (Column.Type.SMALLINT.equals(type)) {
            LocalJavaField s = pMethod.newJavaField(Short.TYPE);
            s.addLine(pResultSet, ".getShort(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = new ", class$java$lang$Short == null ? (class$java$lang$Short = VersionGenerator.class$("java.lang.Short")) : class$java$lang$Short, "(", s, ");");
            pMethod.addEndIf();
        } else if (Column.Type.TIME.equals(type)) {
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = ", pResultSet, ".getTime(", p, ");");
        } else if (Column.Type.TIMESTAMP.equals(type)) {
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = ", pResultSet, ".getTimestamp(", p, ");");
        } else if (Column.Type.TINYINT.equals(type)) {
            LocalJavaField b = pMethod.newJavaField(Short.TYPE);
            b.addLine(pResultSet, ".getByte(", p, ");");
            pMethod.addIf("!", (Object)pResultSet, (Object)".wasNull()");
            pMethod.addLine(pTarget, "[", Integer.toString(pColumnNum), "] = new ", class$java$lang$Byte == null ? (class$java$lang$Byte = VersionGenerator.class$("java.lang.Byte")) : class$java$lang$Byte, "(", b, ");");
            pMethod.addEndIf();
        } else {
            throw new IllegalStateException("Unknown column type: " + type);
        }
    }

    protected void setPreparedStatementValue(JavaMethod pMethod, Column pColumn, Object pStmt, Object pParamNum, Object pValue) {
        if (!(pValue instanceof DirectAccessible)) {
            LocalJavaField v = pMethod.newJavaField(class$java$lang$Object == null ? (class$java$lang$Object = VersionGenerator.class$("java.lang.Object")) : class$java$lang$Object);
            v.addLine(pValue);
            pValue = v;
        }
        Column.Type type = pColumn.getType();
        pMethod.addIf(pValue, (Object)" == null");
        pMethod.addLine(pStmt, ".setNull(", pParamNum, ", ", class$java$sql$Types == null ? (class$java$sql$Types = VersionGenerator.class$("java.sql.Types")) : class$java$sql$Types, ".", type, ");");
        pMethod.addElse();
        if (Column.Type.BIGINT.equals(type)) {
            pMethod.addLine(pStmt, ".setLong(", pParamNum, ", ((", class$java$lang$Long == null ? (class$java$lang$Long = VersionGenerator.class$("java.lang.Long")) : class$java$lang$Long, ") ", pValue, ").longValue());");
        } else if (pColumn.isBinaryColumn()) {
            pMethod.addLine(pStmt, ".setBytes(", pParamNum, ", (", array$B == null ? (array$B = VersionGenerator.class$("[B")) : array$B, ") ", pValue, ");");
        } else if (Column.Type.BIT.equals(type)) {
            pMethod.addLine(pStmt, ".setBoolean(", pParamNum, ", ((", class$java$lang$Boolean == null ? (class$java$lang$Boolean = VersionGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean, ") ", pValue, ").booleanValue());");
        } else if (pColumn.isStringColumn()) {
            pMethod.addLine(pStmt, ".setString(", pParamNum, ", (", class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String, ") ", pValue, ");");
        } else if (Column.Type.DATE.equals(type)) {
            pMethod.addLine(pStmt, ".setDate(", pParamNum, ", (", class$java$sql$Date == null ? (class$java$sql$Date = VersionGenerator.class$("java.sql.Date")) : class$java$sql$Date, ") ", pValue, ");");
        } else if (Column.Type.DOUBLE.equals(type)) {
            pMethod.addLine(pStmt, ".setDouble(", pParamNum, ", ((", class$java$lang$Double == null ? (class$java$lang$Double = VersionGenerator.class$("java.lang.Double")) : class$java$lang$Double, ") ", pValue, ").doubleValue());");
        } else if (Column.Type.FLOAT.equals(type)) {
            pMethod.addLine(pStmt, ".setFloat(", pParamNum, ", ((", class$java$lang$Float == null ? (class$java$lang$Float = VersionGenerator.class$("java.lang.Float")) : class$java$lang$Float, ") ", pValue, ").floatValue());");
        } else if (Column.Type.INTEGER.equals(type)) {
            pMethod.addLine(pStmt, ".setInt(", pParamNum, ", ((", class$java$lang$Integer == null ? (class$java$lang$Integer = VersionGenerator.class$("java.lang.Integer")) : class$java$lang$Integer, ") ", pValue, ").intValue());");
        } else if (Column.Type.SMALLINT.equals(type)) {
            pMethod.addLine(pStmt, ".setShort(", pParamNum, ", ((", class$java$lang$Short == null ? (class$java$lang$Short = VersionGenerator.class$("java.lang.Short")) : class$java$lang$Short, ") ", pValue, ").shortValue());");
        } else if (Column.Type.TIME.equals(type)) {
            pMethod.addLine(pStmt, ".setTime(", pParamNum, ", (", class$java$sql$Time == null ? (class$java$sql$Time = VersionGenerator.class$("java.sql.Time")) : class$java$sql$Time, ") ", pValue, ");");
        } else if (Column.Type.TIMESTAMP.equals(type)) {
            pMethod.addLine(pStmt, ".setTimestamp(", pParamNum, ", (", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = VersionGenerator.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, ") ", pValue, ");");
        } else if (Column.Type.TINYINT.equals(type)) {
            pMethod.addLine(pStmt, ".setByte(", pParamNum, ", ((", class$java$lang$Byte == null ? (class$java$lang$Byte = VersionGenerator.class$("java.lang.Byte")) : class$java$lang$Byte, ") ", pValue, ").byteValue());");
        } else {
            throw new IllegalStateException("Unknown column type: " + type);
        }
        pMethod.addEndIf();
    }

    protected void getSelectRowsCode(JavaMethod pMethod, TableInfo pTableInfo, ColumnSet pColumnSet, DirectAccessible pConn, DirectAccessible pMap, DirectAccessible pValues, boolean pReturnValue) {
        LocalJavaField result;
        Table table = pTableInfo.getTable();
        SelectStatement statement = table.getSelectStatement();
        statement.getWhere().addColumnSetQuery(pColumnSet, statement.getTableReference());
        String s = table.getSchema().getSQLFactory().newSQLGenerator().getQuery(statement);
        Object query = JavaSource.getQuoted(s);
        if (this.isGeneratingLogging()) {
            LocalJavaField q = pMethod.newJavaField(class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String);
            q.addLine(query);
            query = q;
            this.logFinest(pMethod, query, pValues);
        }
        LocalJavaField stmt = pMethod.newJavaField(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = VersionGenerator.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
        stmt.addLine(pConn, ".prepareStatement(", JavaSource.getQuoted(s), ");");
        LocalJavaField isStmtClosed = pMethod.newJavaField(Boolean.TYPE);
        isStmtClosed.addLine("false");
        pMethod.addTry();
        int paramNum = 0;
        Iterator iter = pColumnSet.getColumns();
        while (iter.hasNext()) {
            Object[] v = new Object[]{pValues, "[", Integer.toString(paramNum), "]"};
            Column column = (Column)iter.next();
            this.setPreparedStatementValue(pMethod, column, stmt, Integer.toString(++paramNum), v);
        }
        LocalJavaField rs = pMethod.newJavaField(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = VersionGenerator.class$("java.sql.ResultSet")) : class$java$sql$ResultSet, "rs");
        rs.addLine(stmt, ".executeQuery()");
        LocalJavaField isRsClosed = pMethod.newJavaField(Boolean.TYPE);
        isRsClosed.addLine("false");
        if (pReturnValue) {
            result = pMethod.newJavaField(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "result");
            result.addLine("null");
        } else {
            result = null;
        }
        pMethod.addTry();
        pMethod.addWhile(rs, ".next()");
        if (result != null) {
            pMethod.addIf(result, (Object)" != null");
            pMethod.addThrowNew(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = VersionGenerator.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, (Object)JavaSource.getQuoted("Expected a single row only."));
            pMethod.addEndIf();
        }
        int resultColumnSize = 0;
        Iterator iter2 = table.getColumns();
        while (iter2.hasNext()) {
            ++resultColumnSize;
            iter2.next();
        }
        LocalJavaField row = pMethod.newJavaField(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "row");
        row.addLine("new ", class$java$lang$Object == null ? (class$java$lang$Object = VersionGenerator.class$("java.lang.Object")) : class$java$lang$Object, "[" + resultColumnSize + "];");
        int resultColumnNum = 0;
        Iterator iter3 = table.getColumns();
        while (iter3.hasNext()) {
            Column column = (Column)iter3.next();
            this.setResultSetValue(pMethod, column, rs, resultColumnNum++, row);
        }
        pMethod.addLine(result == null ? "" : "result = ", this.getInsertRowMethodName(pTableInfo), "(", pConn, ", ", pMap, ", ", row, ");");
        pMethod.addEndWhile();
        pMethod.addLine(isRsClosed, " = true;");
        pMethod.addLine(rs, ".close();");
        pMethod.addFinally();
        pMethod.addIf("!", (Object)isRsClosed);
        pMethod.addTry();
        pMethod.addLine(rs, ".close();");
        pMethod.addCatch(class$java$lang$Throwable == null ? (class$java$lang$Throwable = VersionGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable, (Object)"pIgnore");
        pMethod.addEndTry();
        pMethod.addEndIf();
        pMethod.addEndTry();
        pMethod.addLine(isStmtClosed, " = true;");
        pMethod.addLine(stmt, ".close();");
        if (result != null) {
            this.logExiting(pMethod, result);
            pMethod.addLine("return ", result, ";");
        } else {
            this.logFinestExiting(pMethod, null);
        }
        pMethod.addFinally();
        pMethod.addIf("!", (Object)isStmtClosed);
        pMethod.addTry();
        pMethod.addLine(stmt, ".close();");
        pMethod.addCatch(class$java$lang$Throwable == null ? (class$java$lang$Throwable = VersionGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable, (Object)"pIgnore");
        pMethod.addEndTry();
        pMethod.addEndIf();
        pMethod.addEndTry();
    }

    protected String getInsertRowMethodName(TableInfo pTableInfo) {
        return "clone" + pTableInfo.getPropertyName() + "Row";
    }

    protected LocalJavaField getCacheDataClassInstance(JavaMethod pMethod, TableInfo pTableInfo, ColumnSet pColumnSet, DirectAccessible pValues) {
        Table table = pColumnSet.getTable();
        ArrayList<Object> params = new ArrayList<Object>();
        Iterator iter = pColumnSet.getColumns();
        while (iter.hasNext()) {
            Column primaryKeyColumn = (Column)iter.next();
            int index = -1;
            int i = 0;
            Iterator iter2 = table.getColumns();
            while (iter2.hasNext()) {
                Column tableColumn = (Column)iter2.next();
                if (tableColumn.equals(primaryKeyColumn)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                throw new IllegalStateException("Key column " + primaryKeyColumn.getQName() + " not found.");
            }
            if (params.size() > 0) {
                params.add(", ");
            }
            params.add(new Object[]{pValues, "[" + index + "]"});
        }
        JavaQName cacheDataClass = this.getCacheDataClassName(pMethod.getJavaSource().getQName());
        LocalJavaField jf = pMethod.newJavaField(cacheDataClass);
        jf.addLine("new ", cacheDataClass, "(", JavaSource.getQuoted(pTableInfo.getPropertyName()), ", new ", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "{", params, "})");
        return jf;
    }

    protected void getApplyCacheData(JavaMethod pMethod, TableInfo pTableInfo, ColumnSet pColumnSet, DirectAccessible pRow, DirectAccessible pData) {
        Table table = pTableInfo.getTable();
        Iterator iter = pColumnSet.getColumns();
        while (iter.hasNext()) {
            Column primaryKeyColumn = (Column)iter.next();
            int index = -1;
            int i = 0;
            Iterator iter2 = table.getColumns();
            while (iter2.hasNext()) {
                Column tableColumn = (Column)iter2.next();
                if (tableColumn.equals(primaryKeyColumn)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                throw new IllegalStateException("Key column " + primaryKeyColumn.getQName() + " not found.");
            }
            pMethod.addLine(pRow, "[" + index + "] = ", pData, "[" + (i + 1) + "];");
        }
    }

    protected JavaMethod getInsertRowMethod(JavaSource pSource, TableInfo pTableInfo) {
        Table table = pTableInfo.getTable();
        JavaMethod jm = pSource.newJavaMethod(this.getInsertRowMethodName(pTableInfo), array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, JavaSource.PRIVATE);
        jm.addThrows(class$java$sql$SQLException == null ? (class$java$sql$SQLException = VersionGenerator.class$("java.sql.SQLException")) : class$java$sql$SQLException);
        Parameter connection = jm.addParam(class$java$sql$Connection == null ? (class$java$sql$Connection = VersionGenerator.class$("java.sql.Connection")) : class$java$sql$Connection, "pConn");
        Parameter map = jm.addParam(class$java$util$Map == null ? (class$java$util$Map = VersionGenerator.class$("java.util.Map")) : class$java$util$Map, "pMap");
        Parameter values = jm.addParam(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "pValue");
        this.logFinestEntering(jm, values);
        LocalJavaField baseKey = null;
        if (table.getPrimaryKey() != null) {
            baseKey = this.getCacheDataClassInstance(jm, pTableInfo, table.getPrimaryKey(), values);
            jm.addIf(map, (Object)".containsKey(", (Object)baseKey, (Object)")");
            this.logFinestExiting(jm, JavaSource.getQuoted("null (Already cloned)"));
            jm.addLine("return null;");
            jm.addEndIf();
        }
        Iterator iter = pTableInfo.getColumnUpdaters();
        while (iter.hasNext()) {
            ((ColumnUpdater)iter.next()).update(jm, pTableInfo, connection, map, values);
        }
        jm.addLine(jm.getName(), "(", connection, ", ", values, ");");
        if (baseKey != null) {
            LocalJavaField clonedKey = this.getCacheDataClassInstance(jm, pTableInfo, table.getPrimaryKey(), values);
            jm.addLine(map, ".put(", baseKey, ", ", clonedKey, ");");
        }
        LocalJavaField referencedValues = null;
        Iterator referencingIter = this.tablesByOrder.iterator();
        while (referencingIter.hasNext()) {
            TableInfo prevTableInfo = (TableInfo)referencingIter.next();
            Table prevTable = prevTableInfo.getTable();
            Iterator fkIter = prevTable.getForeignKeys();
            while (fkIter.hasNext()) {
                ForeignKey fk = (ForeignKey)fkIter.next();
                if (!fk.getReferencedTable().equals(table)) continue;
                if (referencedValues == null) {
                    referencedValues = jm.newJavaField(array$Ljava$lang$Object == null ? VersionGenerator.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object);
                    referencedValues.addLine(baseKey, ".getValues()");
                }
                this.getSelectRowsCode(jm, prevTableInfo, fk, connection, map, referencedValues, false);
            }
        }
        this.logFinestExiting(jm, values);
        jm.addLine("return ", values, ";");
        return jm;
    }

    protected JavaMethod getInnerInsertRowMethod(JavaSource pSource, TableInfo pTableInfo) {
        Table table = pTableInfo.getTable();
        JavaMethod jm = pSource.newJavaMethod(this.getInsertRowMethodName(pTableInfo), JavaQNameImpl.VOID, JavaSource.PRIVATE);
        jm.addThrows(class$java$sql$SQLException == null ? (class$java$sql$SQLException = VersionGenerator.class$("java.sql.SQLException")) : class$java$sql$SQLException);
        Parameter connection = jm.addParam(class$java$sql$Connection == null ? (class$java$sql$Connection = VersionGenerator.class$("java.sql.Connection")) : class$java$sql$Connection, "pConn");
        Parameter values = jm.addParam(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "pValue");
        this.logFinestEntering(jm, null);
        InsertStatement insertStatement = table.getInsertStatement();
        String s = table.getSchema().getSQLFactory().newSQLGenerator().getQuery(insertStatement);
        Object query = JavaSource.getQuoted(s);
        if (this.isGeneratingLogging()) {
            LocalJavaField q = jm.newJavaField(class$java$lang$String == null ? (class$java$lang$String = VersionGenerator.class$("java.lang.String")) : class$java$lang$String);
            q.addLine(query);
            query = q;
            this.logFinest(jm, query, values);
        }
        LocalJavaField stmt = jm.newJavaField(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = VersionGenerator.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, "stmt");
        stmt.setFinal(true);
        stmt.addLine(connection, ".prepareStatement(", JavaSource.getQuoted(s), ");");
        LocalJavaField isStmtClosed = jm.newJavaField(Boolean.TYPE, "isStmtClosed");
        isStmtClosed.addLine("false");
        jm.addTry();
        int paramNum = 0;
        Iterator iter = table.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            Object[] v = new Object[]{values, "[", Integer.toString(paramNum), "]"};
            this.setPreparedStatementValue(jm, column, stmt, Integer.toString(++paramNum), v);
        }
        jm.addLine(stmt, ".executeUpdate();");
        jm.addLine(isStmtClosed, " = true;");
        jm.addLine(stmt, ".close();");
        jm.addFinally();
        jm.addIf("!", (Object)isStmtClosed);
        jm.addTry();
        jm.addLine(stmt, ".close();");
        jm.addCatch(class$java$lang$Throwable == null ? (class$java$lang$Throwable = VersionGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable, (Object)"ignore");
        jm.addEndTry();
        jm.addEndIf();
        jm.addEndTry();
        this.logFinestExiting(jm, null);
        return jm;
    }

    protected JavaMethod getPublicCloneMethod(JavaSource pSource) {
        Iterator iter = this.tablesByOrder.iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("No tables have been added.");
        }
        TableInfo headTable = (TableInfo)iter.next();
        JavaQName resultType = JavaQNameImpl.getInstance(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
        JavaMethod jm = pSource.newJavaMethod("clone", resultType, JavaSource.PUBLIC);
        jm.addThrows(class$java$sql$SQLException == null ? (class$java$sql$SQLException = VersionGenerator.class$("java.sql.SQLException")) : class$java$sql$SQLException);
        JavaComment jc = jm.newComment();
        jc.addLine("<p>This method takes as input the key values of a row in the table " + headTable.getTable().getQName() + ".");
        jc.addLine("The key values are given by the array <code>pRow</code>:");
        jc.addLine("<ul>");
        int i = 0;
        Iterator iter2 = headTable.getTable().getPrimaryKey().getColumns();
        while (iter2.hasNext()) {
            Column col = (Column)iter2.next();
            jc.addLine("  <li><code>pRow[" + i + "] = " + col.getQName() + "</code></li>");
            ++i;
        }
        jc.addLine("</ul>");
        jc.addLine("The method updates the rows version number and creates a new row");
        jc.addLine("with the updated values.</p>");
        iter2 = this.tablesByOrder.iterator();
        iter2.next();
        if (iter2.hasNext()) {
            jc.addLine("<p>Once the new row is created, the method searches for entries");
            jc.addLine("referencing the old row in the following tables:");
            jc.addLine("<table>");
            do {
                TableInfo subTable = (TableInfo)iter2.next();
                jc.addLine("  <tr><td>" + subTable.getTable().getQName() + "</td></tr>");
            } while (iter2.hasNext());
            jc.addLine("All the referencing entries are cloned as well, with updated");
            jc.addLine("references.");
        }
        Parameter conn = jm.addParam(class$java$sql$Connection == null ? (class$java$sql$Connection = VersionGenerator.class$("java.sql.Connection")) : class$java$sql$Connection, "pConn");
        Parameter row = jm.addParam(resultType, "pRow");
        this.logEntering(jm, new Object[]{"new ", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = VersionGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "{", conn, ", ", row, "}"});
        LocalJavaField map = jm.newJavaField(class$java$util$Map == null ? (class$java$util$Map = VersionGenerator.class$("java.util.Map")) : class$java$util$Map, "clonedObjects");
        map.addLine("new ", class$java$util$HashMap == null ? (class$java$util$HashMap = VersionGenerator.class$("java.util.HashMap")) : class$java$util$HashMap, "()");
        this.getSelectRowsCode(jm, headTable, headTable.getTable().getPrimaryKey(), conn, map, row, true);
        return jm;
    }

    public JavaMethod getCloneMethod(JavaSource pSource) {
        this.initLogging(pSource);
        Iterator iter = this.tablesByOrder.iterator();
        while (iter.hasNext()) {
            TableInfo tableInfo = (TableInfo)iter.next();
            this.getInsertRowMethod(pSource, tableInfo);
            this.getInnerInsertRowMethod(pSource, tableInfo);
        }
        this.getCacheDataClass(pSource);
        this.getPublicCloneMethod(pSource);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ForeignKeyUpdater
    implements ColumnUpdater {
        private final ForeignKey foreignKey;
        private final TableInfo referencedTable;

        private ForeignKeyUpdater(ForeignKey pForeignKey, TableInfo pReferencedTable) {
            this.foreignKey = pForeignKey;
            this.referencedTable = pReferencedTable;
        }

        public void update(JavaMethod pMethod, TableInfo pTableInfo, DirectAccessible pConnection, DirectAccessible pMap, DirectAccessible pRow) {
            LocalJavaField referencedKey = VersionGenerator.this.getCacheDataClassInstance(pMethod, this.referencedTable, this.foreignKey, pRow);
            LocalJavaField mappedKey = pMethod.newJavaField(referencedKey.getType());
            mappedKey.addLine("(", referencedKey.getType(), ") ", pMap, ".get(", referencedKey, ")");
            pMethod.addIf(mappedKey, (Object)" == null");
            pMethod.addThrowNew(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = VersionGenerator.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, (Object)JavaSource.getQuoted("Unknown reference: "), (Object)" + ", (Object)referencedKey);
            pMethod.addEndIf();
            int valNum = 0;
            Iterator iter = this.referencedTable.getTable().getPrimaryKey().getColumns();
            while (iter.hasNext()) {
                Column referencedKeyColumn = (Column)iter.next();
                Column localColumn = null;
                Iterator iter2 = this.foreignKey.getColumnLinks();
                while (iter2.hasNext()) {
                    ForeignKey.ColumnLink link = (ForeignKey.ColumnLink)iter2.next();
                    if (!link.getReferencedColumn().equals(referencedKeyColumn)) continue;
                    localColumn = link.getLocalColumn();
                    break;
                }
                if (localColumn == null) {
                    throw new IllegalStateException("Unable to find the column referencing " + referencedKeyColumn.getQName());
                }
                int colNum = -1;
                int i = 0;
                Iterator iter22 = pTableInfo.getTable().getColumns();
                while (iter22.hasNext()) {
                    Column col = (Column)iter22.next();
                    if (col.equals(localColumn)) {
                        colNum = i;
                        break;
                    }
                    ++i;
                }
                if (colNum == -1) {
                    throw new IllegalStateException("Unable to find the column " + localColumn.getQName() + " in table " + pTableInfo.getTable().getQName());
                }
                pMethod.addLine(pRow, "[" + colNum + "] = ", mappedKey, ".getValues()[" + valNum + "];");
            }
        }
    }

    public static class TableInfo {
        private final Table table;
        private final String propertyName;
        private boolean isReferenced;
        private boolean hasPrimaryKey;
        private final List columnUpdaters = new ArrayList();

        TableInfo(Table pTable, String pPropertyName) {
            this.table = pTable;
            this.propertyName = pPropertyName;
        }

        public Table getTable() {
            return this.table;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void add(ColumnUpdater pColumnUpdater) {
            this.columnUpdaters.add(pColumnUpdater);
        }

        public Iterator getColumnUpdaters() {
            return this.columnUpdaters.iterator();
        }

        public void setReferenced(boolean pReferenced) {
            this.isReferenced = true;
        }

        public boolean isReferenced() {
            return this.isReferenced;
        }

        public boolean hasPrimaryKey() {
            return this.hasPrimaryKey;
        }

        public void setPrimaryKey(boolean pPrimaryKey) {
            this.hasPrimaryKey = pPrimaryKey;
        }
    }

    public static interface ColumnUpdater {
        public void update(JavaMethod var1, TableInfo var2, DirectAccessible var3, DirectAccessible var4, DirectAccessible var5);
    }
}

