/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.ConstraintImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.sqls.impl.ValueImpl;

public class BooleanConstraintImpl
extends ConstraintImpl
implements BooleanConstraint {
    private BooleanConstraint.Type type;
    private List parts = new ArrayList();

    protected BooleanConstraintImpl(CombinedConstraint pCombinedConstraint, BooleanConstraint.Type pType) {
        super(pCombinedConstraint.getConstrainedStatement());
        if (pType == null) {
            throw new NullPointerException("The type must not be null.");
        }
        this.type = pType;
    }

    public BooleanConstraint.Type getType() {
        return this.type;
    }

    private void add(Object o) {
        if (!this.getType().equals(BooleanConstraint.Type.IN)) {
            if (this.getType().equals(BooleanConstraint.Type.ISNULL)) {
                if (this.parts.size() == 1) {
                    throw new IllegalStateException("An IS NULL clause cannot have more than one part.");
                }
            } else if (this.parts.size() == 2) {
                throw new IllegalStateException("An " + this.getType() + " clause cannot have more than two parts.");
            }
        }
        this.parts.add(o);
    }

    public void addPart(Value pValue) {
        if (pValue == null) {
            throw new NullPointerException("A constant value must not be null.");
        }
        this.parts.add(pValue);
    }

    public void addPart(ColumnReference pColumn) {
        if (pColumn == null) {
            throw new NullPointerException("Referenced column must not be null.");
        }
        this.add(pColumn);
    }

    public void addPart(ColumnReference[] pColumns) {
        if (pColumns == null) {
            throw new NullPointerException("The array of referenced columns must not be null.");
        }
        for (int i = 0; i < pColumns.length; ++i) {
            if (pColumns[i] != null) continue;
            throw new NullPointerException("The referenced column with number " + i + " must not be null.");
        }
        this.add(pColumns);
    }

    public void addPart(SelectStatement pStatement) {
        if (pStatement == null) {
            throw new NullPointerException("The subselect statement must not be null.");
        }
        this.add(pStatement);
    }

    public void addPart(String pString) {
        this.add(new ValueImpl(Value.Type.STRING, pString));
    }

    public void addPart() {
        this.add(new ValueImpl(Value.Type.NULL, null));
    }

    public void addPart(byte pByte) {
        this.add(new ValueImpl(Value.Type.BYTE, new Byte(pByte)));
    }

    public void addPart(int pInt) {
        this.add(new ValueImpl(Value.Type.INT, new Integer(pInt)));
    }

    public void addPart(long pLong) {
        this.add(new ValueImpl(Value.Type.LONG, new Long(pLong)));
    }

    public void addPart(short pShort) {
        this.add(new ValueImpl(Value.Type.SHORT, new Short(pShort)));
    }

    public void addPart(float pFloat) {
        this.add(new ValueImpl(Value.Type.FLOAT, new Float(pFloat)));
    }

    public void addPart(double pDouble) {
        this.add(new ValueImpl(Value.Type.DOUBLE, new Double(pDouble)));
    }

    public void addPart(boolean pBoolean) {
        this.add(new ValueImpl(Value.Type.BOOLEAN, pBoolean ? Boolean.TRUE : Boolean.FALSE));
    }

    public void addPlaceholder() {
        this.add(new ValueImpl(Value.Type.PLACEHOLDER, null));
    }

    public int getNumParts() {
        return this.parts.size();
    }

    public Iterator getParts() {
        return this.parts.iterator();
    }

    public static class TypeImpl
    extends SQLFactoryImpl.IdentImpl
    implements BooleanConstraint.Type {
        public TypeImpl(String pName) {
            super(pName);
        }
    }
}

