/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ws.jaxme.sqls.BinaryColumn;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.Constraint;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SetStatement;
import org.apache.ws.jaxme.sqls.Statement;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;

public class SQLGeneratorImpl
implements SQLGenerator {
    private String statementTerminator;
    private String lineTerminator;

    public String getStatementTerminator() {
        return this.statementTerminator;
    }

    public void setStatementTerminator(String pStatementTerminator) {
        this.statementTerminator = pStatementTerminator;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public void setLineTerminator(String pLineTerminator) {
        this.lineTerminator = pLineTerminator;
    }

    protected String newStatement(String pStatement) {
        String s = this.getStatementTerminator();
        return s == null ? pStatement : pStatement + s;
    }

    public Collection getCreate(Schema pSchema) {
        if (pSchema.getName() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("CREATE SCHEMA " + pSchema.getName()));
        return result;
    }

    public Collection getDrop(Schema pSchema) {
        if (pSchema.getName() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("DROP SCHEMA " + pSchema.getName()));
        return result;
    }

    protected String getIndent() {
        return "  ";
    }

    protected String getTypeName(Column.Type pType) {
        if (pType.equals(Column.Type.BIGINT)) {
            return "BIGINT";
        }
        if (pType.equals(Column.Type.BINARY)) {
            return "BINARY";
        }
        if (pType.equals(Column.Type.BIT)) {
            return "BIT";
        }
        if (pType.equals(Column.Type.CHAR)) {
            return "CHAR";
        }
        if (pType.equals(Column.Type.DATE)) {
            return "DATE";
        }
        if (pType.equals(Column.Type.DOUBLE)) {
            return "DOUBLE";
        }
        if (pType.equals(Column.Type.FLOAT)) {
            return "FLOAT";
        }
        if (pType.equals(Column.Type.INTEGER)) {
            return "INT";
        }
        if (pType.equals(Column.Type.SMALLINT)) {
            return "SMALLINT";
        }
        if (pType.equals(Column.Type.TIME)) {
            return "TIME";
        }
        if (pType.equals(Column.Type.TIMESTAMP)) {
            return "TIMESTAMP";
        }
        if (pType.equals(Column.Type.TINYINT)) {
            return "TINYINT";
        }
        if (pType.equals(Column.Type.VARBINARY)) {
            return "VARBINARY";
        }
        if (pType.equals(Column.Type.VARCHAR)) {
            return "VARCHAR";
        }
        if (pType.equals(Column.Type.CLOB)) {
            return "CLOB";
        }
        if (pType.equals(Column.Type.BLOB)) {
            return "BLOB";
        }
        if (pType.equals(Column.Type.OTHER)) {
            return "BLOB";
        }
        throw new IllegalStateException("Unknown column type: " + pType);
    }

    protected String getCreate(Column pColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append(pColumn.getName()).append(" ");
        Column.Type type = pColumn.getType();
        Long length = null;
        if (type.equals(Column.Type.BINARY) || type.equals(Column.Type.VARBINARY) || type.equals(Column.Type.BLOB) || type.equals(Column.Type.OTHER) ? (length = ((BinaryColumn)pColumn).getLength()) == null : (type.equals(Column.Type.CHAR) || type.equals(Column.Type.VARCHAR) || type.equals(Column.Type.CLOB)) && (length = ((StringColumn)pColumn).getLength()) == null) {
            throw new IllegalStateException("The length of column " + pColumn.getQName() + " is not set.");
        }
        sb.append(this.getTypeName(type));
        if (length != null) {
            sb.append("(").append(length).append(")");
        }
        if (!pColumn.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    protected boolean isPrimaryKeyUniqueIndex() {
        return false;
    }

    protected boolean isPrimaryKeyPartOfCreateTable() {
        return false;
    }

    protected boolean isUniqueIndexPartOfCreateTable() {
        return false;
    }

    protected boolean isNonUniqueIndexPartOfCreateTable() {
        return false;
    }

    protected boolean isForeignKeyPartOfCreateTable() {
        return false;
    }

    protected String createPrimaryKeyAsPartOfCreateTable(Table pTable) {
        Index index = pTable.getPrimaryKey();
        if (index == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("PRIMARY KEY").append(" (");
        boolean first = true;
        Iterator iter = index.getColumns();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(((Column)iter.next()).getName().getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected String createIndexAsPartOfCreateTable(Index pIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append(pIndex.isUnique() ? "UNIQUE" : "KEY").append(" (");
        boolean first = true;
        Iterator iter = pIndex.getColumns();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(((Column)iter.next()).getName().getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected String createForeignKeyAsPartOfCreateTable(ForeignKey pKey) {
        ForeignKey.Mode updateMode;
        ForeignKey.ColumnLink link;
        StringBuffer sb = new StringBuffer();
        sb.append("FOREIGN KEY (");
        boolean first = true;
        Iterator iter = pKey.getColumnLinks();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Foreign key on " + pKey.getTable().getQName() + " referencing " + pKey.getReferencedTable().getQName() + " doesn't have any columns.");
        }
        while (iter.hasNext()) {
            link = (ForeignKey.ColumnLink)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(link.getLocalColumn().getName().getName());
        }
        sb.append(") REFERENCES ");
        sb.append(pKey.getReferencedTable().getQName());
        sb.append(" (");
        first = true;
        iter = pKey.getColumnLinks();
        while (iter.hasNext()) {
            link = (ForeignKey.ColumnLink)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(link.getReferencedColumn().getName().getName());
        }
        sb.append(")");
        ForeignKey.Mode deleteMode = pKey.getOnDelete();
        if (deleteMode != null) {
            if (ForeignKey.Mode.CASCADE.equals(deleteMode)) {
                sb.append(" ON DELETE CASCADE");
            } else if (ForeignKey.Mode.REJECT.equals(deleteMode)) {
                sb.append(" ON DELETE RESTRICT");
            } else if (ForeignKey.Mode.SETNULL.equals(deleteMode)) {
                sb.append(" ON DELETE SET NULL");
            } else {
                throw new IllegalStateException("Unknown foreign key mode for ON  DELETE: " + deleteMode);
            }
        }
        if ((updateMode = pKey.getOnUpdate()) != null) {
            if (ForeignKey.Mode.CASCADE.equals(updateMode)) {
                sb.append(" ON UPDATE CASCADE");
            } else if (ForeignKey.Mode.REJECT.equals(updateMode)) {
                sb.append(" ON UPDATE RESTRICT");
            } else {
                throw new IllegalStateException("Unknown foreign key mode for ON UPDATE: " + updateMode);
            }
        }
        return sb.toString();
    }

    protected String getCreateTableHeader(Table pTable) {
        return "CREATE TABLE " + pTable.getQName();
    }

    public Collection getCreate(Table pTable) {
        String st;
        String lf = this.getLineTerminator() == null ? "" : this.getLineTerminator();
        String indent = lf == null ? "" : this.getIndent();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCreateTableHeader(pTable)).append(" (");
        String s = lf + indent;
        Iterator iter = pTable.getColumns();
        while (iter.hasNext()) {
            sb.append(s).append(this.getCreate((Column)iter.next()));
            s = "," + lf + indent;
        }
        iter = pTable.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (index.isPrimaryKey() && !this.isPrimaryKeyUniqueIndex()) {
                if (!this.isPrimaryKeyPartOfCreateTable()) continue;
                st = this.createPrimaryKeyAsPartOfCreateTable(pTable);
            } else if (index.isUnique()) {
                if (!this.isUniqueIndexPartOfCreateTable()) continue;
                st = this.createIndexAsPartOfCreateTable(index);
            } else {
                if (!this.isNonUniqueIndexPartOfCreateTable()) continue;
                st = this.createIndexAsPartOfCreateTable(index);
            }
            if (st == null) continue;
            sb.append(s).append(st);
        }
        if (this.isForeignKeyPartOfCreateTable()) {
            iter = pTable.getForeignKeys();
            while (iter.hasNext()) {
                ForeignKey key = (ForeignKey)iter.next();
                st = this.createForeignKeyAsPartOfCreateTable(key);
                if (st == null) continue;
                sb.append(s).append(st);
            }
        }
        sb.append(lf).append(")").append(lf);
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement(sb.toString()));
        return result;
    }

    public Collection getDrop(Table pTable) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.newStatement("DROP TABLE " + pTable.getQName()));
        return result;
    }

    public String getInsertQuery(InsertStatement pQuery) {
        SetStatement.SetValue setValue;
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO ");
        result.append(this.getTableAlias(pQuery.getTableReference()));
        boolean first = true;
        Iterator iter = pQuery.getSetValues();
        while (iter.hasNext()) {
            if (first) {
                result.append(" (");
                first = false;
            } else {
                result.append(", ");
            }
            setValue = (SetStatement.SetValue)iter.next();
            result.append(this.getColumnAlias(null, setValue.getColumnReference()));
        }
        if (!first) {
            result.append(")");
        }
        result.append(" VALUES (");
        first = true;
        iter = pQuery.getSetValues();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            setValue = (SetStatement.SetValue)iter.next();
            result.append(this.getValue(setValue.getValue()));
        }
        result.append(")");
        return this.newStatement(result.toString());
    }

    protected String getValue(Value pValue) {
        Value.Type type = pValue.getType();
        Object o = pValue.getValue();
        if (Value.Type.BOOLEAN.equals(type)) {
            return o == null ? "null" : ((Boolean)o != false ? "TRUE" : "FALSE");
        }
        if (Value.Type.BYTE.equals(type) || Value.Type.SHORT.equals(type) || Value.Type.INT.equals(type) || Value.Type.LONG.equals(type) || Value.Type.FLOAT.equals(type) || Value.Type.DOUBLE.equals(type)) {
            return o == null ? "null" : o.toString();
        }
        if (Value.Type.DATE.equals(type) || Value.Type.DATETIME.equals(type) || Value.Type.TIME.equals(type)) {
            throw new IllegalStateException("Date/time handling not yet implemented.");
        }
        if (Value.Type.DATE.equals(type)) {
            throw new IllegalStateException("Date handling not yet implemented.");
        }
        if (Value.Type.PLACEHOLDER.equals(type)) {
            return "?";
        }
        if (Value.Type.STRING.equals(type)) {
            return o == null ? "null" : this.getEscapedString(o.toString());
        }
        if (Value.Type.NULL.equals(type)) {
            return "null";
        }
        throw new IllegalStateException("Unknown value type: " + type);
    }

    protected String getUpdateQuery(UpdateStatement pQuery) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(this.getTableAlias(pQuery.getTableReference()));
        sb.append(" SET ");
        boolean first = true;
        Iterator iter = pQuery.getSetValues();
        while (iter.hasNext()) {
            SetStatement.SetValue setValue = (SetStatement.SetValue)iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getColumnAlias(null, setValue.getColumnReference()));
            sb.append("=");
            sb.append(this.getValue(setValue.getValue()));
        }
        String s = this.getWhereClause(null, pQuery.getWhere());
        if (s != null) {
            sb.append(" WHERE ").append(s);
        }
        return this.newStatement(sb.toString());
    }

    protected String getDeleteQuery(DeleteStatement pQuery) {
        StringBuffer result = new StringBuffer("DELETE FROM ");
        result.append(this.getTableAlias(pQuery.getTableReference()));
        String s = this.getWhereClause(null, pQuery.getWhere());
        if (s != null) {
            result.append(" WHERE ");
            result.append(s);
        }
        return result.toString();
    }

    private String getUniqueAlias(String pSuggestion, Map pAliases) {
        String s;
        char c;
        String prefix = pSuggestion == null ? "" : pSuggestion;
        if (!pAliases.containsKey(prefix)) {
            return prefix;
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            s = prefix + c;
            if (pAliases.containsKey(s)) continue;
            return s;
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            s = prefix + c;
            if (pAliases.containsKey(s)) continue;
            return s;
        }
        return this.getUniqueAlias(prefix + '0', pAliases);
    }

    protected boolean isQualifiedColumn(Map pColumnCounts, ColumnReference pColumn) {
        if (pColumnCounts == null) {
            return false;
        }
        Integer num = (Integer)pColumnCounts.get(pColumn.getColumn().getName().toString().toUpperCase());
        if (num == null) {
            throw new IllegalStateException("Column not in map of column counts.");
        }
        return num > 1;
    }

    protected String getColumnAlias(Map pColumnCounts, ColumnReference pColumn) {
        Column col = pColumn.getColumn();
        String s = col.getName().toString();
        if (col.isVirtual()) {
            VirtualColumn virtCol = (VirtualColumn)col;
            return virtCol.getValue() + " AS " + s;
        }
        if (this.isQualifiedColumn(pColumnCounts, pColumn)) {
            TableReference tableReference = pColumn.getTableReference();
            s = tableReference.getAlias() != null ? tableReference.getAlias().getName() + "." + s : tableReference.getTable().getName() + "." + s;
        }
        if (pColumn.getAlias() != null) {
            s = s + " AS " + pColumn.getAlias().getName();
        }
        return s;
    }

    protected String getColumnAlias(Map pColumnCounts, ColumnReference[] pColumn) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < pColumn.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getColumnAlias(pColumnCounts, pColumn[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isTableAliasUsingAs() {
        return true;
    }

    protected String getTableAlias(TableReference pTable) {
        Table.Name alias;
        Schema.Name schemaName = pTable.getTable().getSchema().getName();
        String tableName = pTable.getTable().getName().getName();
        if (schemaName != null) {
            tableName = schemaName.getName() + "." + tableName;
        }
        if ((alias = pTable.getAlias()) != null) {
            tableName = this.isTableAliasUsingAs() ? tableName + " AS " + alias.getName() : tableName + " " + alias.getName();
        }
        return tableName;
    }

    protected String getJoinAlias(Map pColumnCounts, JoinReference pJoinReference) {
        StringBuffer result = new StringBuffer();
        if (pJoinReference.isLeftOuterJoin()) {
            result.append(" LEFT OUTER JOIN ");
        } else if (pJoinReference.isJoin()) {
            result.append(" JOIN ");
        } else {
            throw new IllegalStateException("Unknown join type");
        }
        result.append(this.getTableAlias(pJoinReference));
        String s = this.getWhereClause(pColumnCounts, pJoinReference.getOn());
        if (s != null) {
            result.append(" ON ");
            result.append(s);
        }
        return result.toString();
    }

    protected String getEscapedString(String s) {
        if (s.indexOf(10) > -1 || s.indexOf(13) > -1 || s.indexOf(12) > -1) {
            throw new IllegalArgumentException("Don't know how to handle line or page terminators.");
        }
        if (s.indexOf(39) > -1) {
            throw new IllegalArgumentException("Don't know how to handle the char ' in strings.");
        }
        return "'" + s + "'";
    }

    protected String getBooleanConstraintPart(Map pColumnCounts, Object o) {
        if (o instanceof Value) {
            return this.getValue((Value)o);
        }
        if (o instanceof ColumnReference) {
            return this.getColumnAlias(pColumnCounts, (ColumnReference)o);
        }
        if (o instanceof ColumnReference[]) {
            return this.getColumnAlias(pColumnCounts, (ColumnReference[])o);
        }
        if (o instanceof SelectStatement) {
            return this.getQuery((SelectStatement)o);
        }
        throw new IllegalArgumentException("Invalid part of a boolean constraint: " + o.getClass().getName());
    }

    protected String getBooleanConstraintType(BooleanConstraint.Type pType) {
        if (BooleanConstraint.Type.EQ.equals(pType)) {
            return "=";
        }
        if (BooleanConstraint.Type.NE.equals(pType)) {
            return "<>";
        }
        if (BooleanConstraint.Type.GT.equals(pType)) {
            return ">";
        }
        if (BooleanConstraint.Type.LT.equals(pType)) {
            return "<";
        }
        if (BooleanConstraint.Type.GE.equals(pType)) {
            return ">=";
        }
        if (BooleanConstraint.Type.LE.equals(pType)) {
            return "<=";
        }
        if (BooleanConstraint.Type.LIKE.equals(pType)) {
            return " LIKE ";
        }
        throw new IllegalArgumentException("Invalid type: " + pType);
    }

    /*
     * WARNING - void declaration
     */
    protected String getBooleanConstraint(Map pColumnCounts, BooleanConstraint pConstraint) {
        void var6_6;
        int expected;
        StringBuffer result = new StringBuffer();
        Iterator parts = pConstraint.getParts();
        if (!parts.hasNext()) {
            throw new NullPointerException("A boolean constraint must have its parts set.");
        }
        result.append(this.getBooleanConstraintPart(pColumnCounts, parts.next()));
        BooleanConstraint.Type type = pConstraint.getType();
        if (BooleanConstraint.Type.EQ.equals(type) || BooleanConstraint.Type.NE.equals(type) || BooleanConstraint.Type.GT.equals(type) || BooleanConstraint.Type.LT.equals(type) || BooleanConstraint.Type.GE.equals(type) || BooleanConstraint.Type.LE.equals(type) || BooleanConstraint.Type.LIKE.equals(type)) {
            expected = 2;
            if (!parts.hasNext()) {
                throw new NullPointerException("The boolean constraint " + type + " must have exactly two parts set.");
            }
            result.append(this.getBooleanConstraintType(type));
            result.append(this.getBooleanConstraintPart(pColumnCounts, parts.next()));
        } else if (BooleanConstraint.Type.ISNULL.equals(type)) {
            expected = 1;
            result.append(" IS NULL");
        } else if (BooleanConstraint.Type.IN.equals(type)) {
            expected = 0;
            String add = "(";
            result.append(" IN ");
            while (parts.hasNext()) {
                result.append(add);
                add = ",";
                result.append(this.getBooleanConstraintPart(pColumnCounts, parts.next()));
            }
            if (",".equals(add)) {
                result.append(")");
            }
        } else {
            throw new IllegalArgumentException("Invalid boolean constraint type: " + type);
        }
        if (var6_6 != false && parts.hasNext()) {
            throw new NullPointerException("The boolean constraint " + type + " must have exactly " + (int)var6_6 + " parts set, but has " + pConstraint.getNumParts());
        }
        return result.toString();
    }

    protected String getCombinedConstraint(Map pColumnCounts, CombinedConstraint pConstraint) {
        if (pConstraint.getNumParts() == 0) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        Iterator iter = pConstraint.getParts();
        while (iter.hasNext()) {
            String s;
            Object o = iter.next();
            if (o == null) {
                throw new NullPointerException("A CombinedConstraints part must not be null");
            }
            if (o instanceof CombinedConstraint) {
                s = this.getCombinedConstraint(pColumnCounts, (CombinedConstraint)o);
            } else if (o instanceof BooleanConstraint) {
                s = this.getBooleanConstraint(pColumnCounts, (BooleanConstraint)o);
            } else {
                throw new IllegalArgumentException("Invalid part: " + o.getClass().getName());
            }
            if (s == null) continue;
            parts.add(s);
        }
        switch (parts.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)parts.get(0);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parts.size(); ++i) {
            if (i == 0) {
                sb.append("(");
            } else {
                sb.append(" ");
                sb.append(pConstraint.getType());
                sb.append(" ");
            }
            sb.append(parts.get(i));
        }
        if (parts.size() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getConstraint(Map pColumnCounts, Constraint pConstraint) {
        if (pConstraint instanceof CombinedConstraint) {
            return this.getWhereClause(pColumnCounts, (CombinedConstraint)pConstraint);
        }
        if (pConstraint instanceof BooleanConstraint) {
            return this.getBooleanConstraint(pColumnCounts, (BooleanConstraint)pConstraint);
        }
        throw new IllegalArgumentException("Unknown constraint type: " + pConstraint.getClass().getName());
    }

    protected String getWhereClause(Map pColumnCounts, CombinedConstraint pWhereClause) {
        return this.getCombinedConstraint(pColumnCounts, pWhereClause);
    }

    protected String getSelectQuery(SelectStatement pQuery) {
        String whereClause;
        Object alias;
        TableReference tableReference;
        StringBuffer sb = new StringBuffer("SELECT");
        if (pQuery.isDistinct()) {
            sb.append(" DISTINCT");
        }
        HashMap<Object, TableReference> aliases = new HashMap<Object, TableReference>();
        ArrayList<TableReference> tables = new ArrayList<TableReference>();
        Iterator tableIter = pQuery.getSelectTableReferences();
        while (tableIter.hasNext()) {
            tableReference = (TableReference)tableIter.next();
            alias = tableReference.getAlias();
            if (alias != null) {
                if (aliases.containsKey(alias.getName())) {
                    throw new NullPointerException("The alias " + alias + " is used twice for the tables " + ((TableReference)aliases.get(alias)).getTable().getName() + " and " + tableReference.getTable().getName());
                }
                aliases.put(alias.getName(), tableReference);
            }
            tables.add(tableReference);
        }
        if (tables.size() > 1) {
            Iterator iter = tables.iterator();
            while (iter.hasNext()) {
                tableReference = (TableReference)iter.next();
                if (tableReference.getAlias() != null) continue;
                alias = this.getUniqueAlias(tableReference.getTable().getName().getName(), aliases);
                aliases.put(alias, tableReference);
                if (((String)alias).equals(tableReference.getTable().getName().getName())) continue;
                tableReference.setAlias((String)alias);
            }
        }
        HashMap<String, Integer> columnNames = new HashMap<String, Integer>();
        for (int i = 0; i < tables.size(); ++i) {
            TableReference table = (TableReference)tables.get(i);
            Iterator iter = table.getTable().getColumns();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                String key = col.getName().toString().toUpperCase();
                Integer num = (Integer)columnNames.get(key);
                num = num == null ? new Integer(1) : new Integer(num + 1);
                columnNames.put(key, num);
            }
        }
        Iterator columnIter = pQuery.getResultColumns();
        if (!columnIter.hasNext()) {
            sb.append(" *");
        } else {
            boolean first = true;
            do {
                ColumnReference column = (ColumnReference)columnIter.next();
                if (first) {
                    sb.append(" ");
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.getColumnAlias(columnNames, column));
            } while (columnIter.hasNext());
        }
        if (tables.size() > 0) {
            sb.append(" FROM ");
            for (int i = 0; i < tables.size(); ++i) {
                TableReference table = (TableReference)tables.get(i);
                if (i == 0) {
                    sb.append(this.getTableAlias(table));
                    continue;
                }
                sb.append(this.getJoinAlias(columnNames, (JoinReference)table));
            }
        }
        if ((whereClause = this.getWhereClause(columnNames, pQuery.getWhere())) != null) {
            sb.append(" WHERE ");
            sb.append(whereClause);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getQuery(Statement pStatement) {
        void var2_2;
        String s;
        if (pStatement instanceof InsertStatement) {
            s = this.getInsertQuery((InsertStatement)pStatement);
        } else if (pStatement instanceof UpdateStatement) {
            s = this.getUpdateQuery((UpdateStatement)pStatement);
        } else if (pStatement instanceof DeleteStatement) {
            s = this.getDeleteQuery((DeleteStatement)pStatement);
        } else if (pStatement instanceof SelectStatement) {
            s = this.getSelectQuery((SelectStatement)pStatement);
        } else {
            throw new IllegalArgumentException("The Statement is neither an INSERT, UPDATE, DELETE nor a SELECT statement.");
        }
        return this.newStatement((String)var2_2);
    }

    public Collection getCreate(Schema pSchema, boolean pAll) {
        if (!pAll) {
            return this.getCreate(pSchema);
        }
        ArrayList result = new ArrayList();
        result.addAll(this.getCreate(pSchema));
        Iterator iter = pSchema.getTables();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            result.addAll(this.getCreate(table, true));
        }
        return result;
    }

    public Collection getDrop(Schema pSchema, boolean pAll) {
        if (!pAll) {
            return this.getDrop(pSchema);
        }
        ArrayList result = new ArrayList();
        ArrayList tables = new ArrayList();
        Iterator iter = pSchema.getTables();
        while (iter.hasNext()) {
            tables.add(iter.next());
        }
        Collections.reverse(tables);
        iter = tables.iterator();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            result.addAll(this.getDrop(table, true));
        }
        result.addAll(this.getDrop(pSchema));
        return result;
    }

    public Collection getCreate(Table pTable, boolean pAll) {
        if (!pAll) {
            return this.getCreate(pTable);
        }
        ArrayList result = new ArrayList();
        result.addAll(this.getCreate(pTable));
        Iterator iter = pTable.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (index.isPrimaryKey() && !this.isPrimaryKeyUniqueIndex() ? this.isPrimaryKeyPartOfCreateTable() : (index.isUnique() ? this.isUniqueIndexPartOfCreateTable() : this.isNonUniqueIndexPartOfCreateTable())) continue;
            result.addAll(this.getCreate(index));
        }
        if (!this.isForeignKeyPartOfCreateTable()) {
            iter = pTable.getForeignKeys();
            while (iter.hasNext()) {
                ForeignKey key = (ForeignKey)iter.next();
                result.addAll(this.getCreate(key));
            }
        }
        return result;
    }

    public Collection getDrop(Table pTable, boolean pAll) {
        if (!pAll) {
            return this.getDrop(pTable);
        }
        ArrayList result = new ArrayList();
        Iterator iter = pTable.getIndexes();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            result.addAll(this.getDrop(index));
        }
        iter = pTable.getForeignKeys();
        while (iter.hasNext()) {
            ForeignKey key = (ForeignKey)iter.next();
            result.addAll(this.getDrop(key));
        }
        result.addAll(this.getDrop(pTable));
        return result;
    }

    public Collection getCreate(Index pIndex) {
        ArrayList<String> result = new ArrayList<String>();
        String s = this.createIndexAsPartOfCreateTable(pIndex);
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("CREATE");
            if (pIndex.isUnique()) {
                sb.append(" UNIQUE");
            }
            sb.append(" INDEX");
            sb.append(" ");
            sb.append(pIndex.getName());
            sb.append(" ON ").append(pIndex.getTable().getQName()).append(" (");
            boolean first = true;
            Iterator iter = pIndex.getColumns();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(((Column)iter.next()).getName().getName());
            }
            sb.append(")");
            result.add(this.newStatement(sb.toString()));
        }
        return result;
    }

    public Collection getDrop(Index pIndex) {
        return Collections.EMPTY_SET;
    }

    public Collection getCreate(ForeignKey pKey) {
        ArrayList<String> result = new ArrayList<String>();
        String s = this.createForeignKeyAsPartOfCreateTable(pKey);
        if (s != null) {
            result.add(this.newStatement("CREATE " + s));
        }
        return result;
    }

    public Collection getDrop(ForeignKey pKey) {
        return Collections.EMPTY_SET;
    }
}

