/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.impl.ConstrainedStatementImpl;
import org.apache.ws.jaxme.sqls.impl.SelectTableReferenceImpl;

public class SelectStatementImpl
extends ConstrainedStatementImpl
implements SelectStatement {
    private List orderColumns = new ArrayList();
    private List resultColumns = new ArrayList();
    private boolean distinct;
    private int maxRows;
    private int skippedRows;

    public SelectStatementImpl(SQLFactory pFactory) {
        super(pFactory);
    }

    public void addOrderColumn(ColumnReference pColumn) {
        this.addOrderColumn(pColumn, false);
    }

    public void addOrderColumn(ColumnReference pColumn, boolean pDescending) {
        this.addOrderColumn(new OrderColumnImpl(pColumn, pDescending));
    }

    public void addOrderColumn(SelectStatement.OrderColumn pColumn) {
        Iterator iter = this.orderColumns.iterator();
        while (iter.hasNext()) {
            SelectStatement.OrderColumn column = (SelectStatement.OrderColumn)iter.next();
            if (!column.getColumn().equals(pColumn) || pColumn.getColumn().getTableReference() != column.getColumn().getTableReference()) continue;
            throw new NullPointerException("The column " + pColumn.getColumn().getColumn().getName() + " is  already used for sorting.");
        }
        this.orderColumns.add(pColumn);
    }

    public void addResultColumn(ColumnReference pColumn) {
        this.resultColumns.add(pColumn);
    }

    public Iterator getResultColumns() {
        return this.resultColumns.iterator();
    }

    public void setDistinct(boolean pDistinct) {
        this.distinct = pDistinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setMaxRows(int pMaxRows) {
        this.maxRows = pMaxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setSkippedRows(int pSkippedRows) {
        this.skippedRows = pSkippedRows;
    }

    public int getSkippedRows() {
        return this.skippedRows;
    }

    protected TableReference newTableReference(Table pTable) {
        return new SelectTableReferenceImpl(this, pTable);
    }

    public SelectTableReference getSelectTableReference() {
        return (SelectTableReference)this.getTableReference();
    }

    public Iterator getSelectTableReferences() {
        return new Iterator(){
            SelectTableReference reference;
            {
                this.reference = SelectStatementImpl.this.getSelectTableReference();
            }

            public boolean hasNext() {
                return this.reference != null;
            }

            public Object next() {
                SelectTableReference result = this.reference;
                this.reference = result.getRightJoinedTableReference();
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class OrderColumnImpl
    implements SelectStatement.OrderColumn {
        private ColumnReference columnReference;
        private boolean descending;

        public OrderColumnImpl(ColumnReference pColumnReference, boolean pDescending) {
            this.columnReference = pColumnReference;
            this.descending = pDescending;
        }

        public ColumnReference getColumn() {
            return this.columnReference;
        }

        public boolean isDescending() {
            return this.descending;
        }
    }
}

