/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;

public class CreateTest
extends TestCase {
    private SQLFactory sqlFactory;
    private Schema schema;

    protected SQLFactory newSQLFactory() {
        return new SQLFactoryImpl();
    }

    public void setUp() {
        this.sqlFactory = this.newSQLFactory();
        this.schema = this.sqlFactory.newSchema("MySchema");
    }

    public CreateTest(String pName) {
        super(pName);
    }

    protected Table getBasicTable() {
        Table table = this.schema.newTable("MyTable");
        Column myIndex = table.newColumn("MyIndex", Column.Type.INTEGER);
        CreateTest.assertTrue((!myIndex.isStringColumn() ? 1 : 0) != 0);
        CreateTest.assertTrue((!myIndex.isBinaryColumn() ? 1 : 0) != 0);
        Column myName = table.newColumn("MyName", Column.Type.VARCHAR);
        CreateTest.assertTrue((boolean)myName.isStringColumn());
        CreateTest.assertTrue((!myName.isBinaryColumn() ? 1 : 0) != 0);
        ((StringColumn)myName).setLength(60L);
        Column myDate = table.newColumn("MyDate", Column.Type.DATE);
        CreateTest.assertTrue((!myDate.isStringColumn() ? 1 : 0) != 0);
        CreateTest.assertTrue((!myDate.isBinaryColumn() ? 1 : 0) != 0);
        myDate.setNullable(true);
        return table;
    }

    protected Table getPrimaryKeyTable() {
        Table table = this.getBasicTable();
        Index index = table.newPrimaryKey();
        index.addColumn("MyIndex");
        return table;
    }

    protected Table getForeignKeyTable(Table pTable) {
        Table otherTable = pTable.getSchema().newTable("OtherTable");
        Column otherIndex = otherTable.newColumn("MyIndex", Column.Type.INTEGER);
        Column referenceColumn = otherTable.newColumn("RefIndex", Column.Type.INTEGER);
        Column companyColumn = otherTable.newColumn("Company", Column.Type.VARCHAR);
        ((StringColumn)companyColumn).setLength(60L);
        otherTable.newPrimaryKey().addColumn(otherIndex);
        ForeignKey reference = otherTable.newForeignKey(pTable);
        reference.addColumnLink(referenceColumn, pTable.getColumn("MyIndex"));
        return otherTable;
    }

    public void testBasicCreate() {
        Table table = this.getBasicTable();
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        Collection statements = generator.getCreate(table.getSchema(), true);
        Iterator iter = statements.iterator();
        CreateTest.assertTrue((boolean)iter.hasNext());
        CreateTest.assertEquals((Object)"CREATE SCHEMA MySchema", iter.next());
        CreateTest.assertTrue((boolean)iter.hasNext());
        CreateTest.assertEquals((Object)"CREATE TABLE MySchema.MyTable (\n  MyIndex INT NOT NULL,\n  MyName VARCHAR(60) NOT NULL,\n  MyDate DATE\n)\n", iter.next());
        CreateTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testBasicInsert() {
        Table table = this.getBasicTable();
        InsertStatement insertStatement = table.getInsertStatement();
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(insertStatement);
        CreateTest.assertEquals((Object)"INSERT INTO MySchema.MyTable (MyIndex, MyName, MyDate) VALUES (?, ?, ?)", (Object)s);
    }

    public void testBasicSelect() {
        Table table = this.getBasicTable();
        SelectStatement selectStatement = table.getSelectStatement();
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(selectStatement);
        CreateTest.assertEquals((Object)"SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable", (Object)s);
    }

    public void testBasicUpdate() {
        Table table = this.getPrimaryKeyTable();
        UpdateStatement updateStatement = table.getUpdateStatement();
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(updateStatement);
        CreateTest.assertEquals((Object)"UPDATE MySchema.MyTable SET MyName=?, MyDate=? WHERE MyIndex=?", (Object)s);
    }

    public void testBasicDelete() {
        Table table = this.getPrimaryKeyTable();
        DeleteStatement deleteStatement = table.getDeleteStatement();
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(deleteStatement);
        CreateTest.assertEquals((Object)"DELETE FROM MySchema.MyTable WHERE MyIndex=?", (Object)s);
    }

    protected String getCreateForeignKeyResult() {
        return "CREATE TABLE MySchema.OtherTable (  MyIndex INT NOT NULL,  RefIndex INT NOT NULL,  Company VARCHAR(60) NOT NULL)";
    }

    public void testCreateForeignKey() {
        Table table = this.getPrimaryKeyTable();
        Table otherTable = this.getForeignKeyTable(table);
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        Collection c = generator.getCreate(otherTable);
        CreateTest.assertEquals((int)1, (int)c.size());
        String expect = this.getCreateForeignKeyResult();
        String got = (String)c.iterator().next();
        CreateTest.assertEquals((Object)expect, (Object)got);
    }

    public void testJoin() {
        Table table = this.getPrimaryKeyTable();
        Table otherTable = this.getForeignKeyTable(table);
        SelectStatement statement = otherTable.getSelectStatement();
        SelectTableReference tableReference = statement.getSelectTableReference();
        JoinReference joinReference = tableReference.join(table);
        SelectTableReference refLocal = tableReference;
        JoinReference refRef = tableReference.getRightJoinedTableReference();
        joinReference.getOn().addJoin((ForeignKey)otherTable.getForeignKeys().next(), refLocal, refRef);
        CombinedConstraint cc = statement.getWhere();
        BooleanConstraint bc = cc.createEQ();
        bc.addPart(tableReference.newColumnReference("MyIndex"));
        bc.addPlaceholder();
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        String got = generator.getQuery(statement);
        String expect = "SELECT MyIndex, RefIndex, Company FROM MySchema.OtherTable JOIN MySchema.MyTable ON RefIndex=MyIndex WHERE MyIndex=?";
        CreateTest.assertEquals((Object)expect, (Object)got);
    }

    protected Table getComposedKeyTable() {
        Table table = this.getPrimaryKeyTable();
        Column verNumColumn = table.newColumn("VerNum", Column.Type.INTEGER);
        CreateTest.assertTrue((!verNumColumn.isStringColumn() ? 1 : 0) != 0);
        CreateTest.assertTrue((!verNumColumn.isBinaryColumn() ? 1 : 0) != 0);
        Index index = table.getPrimaryKey();
        index.addColumn("VerNum");
        return table;
    }

    public void testComposedPrimaryKey() {
        Table table = this.getComposedKeyTable();
        SelectStatement statement = table.getSelectStatement();
        statement.getWhere().addColumnSetQuery(table.getPrimaryKey(), statement.getTableReference());
        SQLGenerator generator = this.sqlFactory.newSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(statement);
        CreateTest.assertEquals((Object)"SELECT MyIndex, MyName, MyDate, VerNum FROM MySchema.MyTable WHERE (MyIndex=? AND VerNum=?)", (Object)s);
    }

    public void testIndexNames() {
        SQLGenerator gen = this.sqlFactory.newSQLGenerator();
        Table table = this.getBasicTable();
        for (int i = 0; i < 10; ++i) {
            Index index = table.newIndex();
            index.addColumn("MyName");
            String s = (String)gen.getCreate(index).iterator().next();
            CreateTest.assertEquals((Object)("CREATE INDEX MyTable_I" + i + " ON MySchema.MyTable (MyName)"), (Object)s);
        }
        Collection coll = gen.getCreate(this.schema, true);
        String[] cmds = coll.toArray(new String[coll.size()]);
        CreateTest.assertEquals((int)12, (int)cmds.length);
        CreateTest.assertEquals((Object)"CREATE SCHEMA MySchema", (Object)cmds[0]);
        CreateTest.assertEquals((Object)"CREATE TABLE MySchema.MyTable (  MyIndex INT NOT NULL,  MyName VARCHAR(60) NOT NULL,  MyDate DATE)", (Object)cmds[1]);
        for (int i = 0; i < 10; ++i) {
            CreateTest.assertEquals((Object)("CREATE INDEX MyTable_I" + i + " ON MySchema.MyTable (MyName)"), (Object)cmds[i + 2]);
        }
    }

    public void testSubSelect() {
        SQLGenerator gen = this.sqlFactory.newSQLGenerator();
        Table table = this.getComposedKeyTable();
        Table otherTable = table.getSchema().newTable("OtherTable");
        Column otherIndex = otherTable.newColumn("MyIndex", Column.Type.INTEGER);
        otherTable.newPrimaryKey().addColumn(otherIndex);
        ForeignKey foreignKey = otherTable.newForeignKey(table);
        SelectStatement selectStatement = this.sqlFactory.newSelectStatement();
        selectStatement.setTable(otherTable);
        DeleteStatement deleteStatement = this.sqlFactory.newDeleteStatement();
        deleteStatement.setTable(table);
        ArrayList<ColumnReference> columns = new ArrayList<ColumnReference>();
        Iterator iter = table.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            Column refColumn = otherTable.newColumn("Ref" + column.getName(), column.getType());
            foreignKey.addColumnLink(refColumn, column);
            if (!column.isPrimaryKeyPart()) continue;
            selectStatement.addResultColumn(selectStatement.getTableReference().newColumnReference(refColumn));
            columns.add(deleteStatement.getTableReference().newColumnReference(column));
        }
        BooleanConstraint eq = selectStatement.getWhere().createEQ();
        eq.addPart(selectStatement.getTableReference().newColumnReference("RefMyName"));
        eq.addPlaceholder();
        BooleanConstraint bc = deleteStatement.getWhere().createIN();
        bc.addPart(columns.toArray(new ColumnReference[columns.size()]));
        bc.addPart(selectStatement);
        String expect = "DELETE FROM MySchema.MyTable WHERE (MyIndex, VerNum) IN (SELECT RefMyIndex, RefVerNum FROM MySchema.OtherTable WHERE RefMyName=?)";
        String got = gen.getQuery(deleteStatement);
        CreateTest.assertEquals((Object)expect, (Object)got);
    }

    public void testVirtualColumn() {
        Table table = this.getBasicTable();
        SelectStatement selectStatement = table.getSelectStatement();
        VirtualColumn col = new VirtualColumn("virtCol", Column.Type.VARCHAR);
        selectStatement.addResultColumn(col);
        col.setValue("null");
        SQLGenerator gen = this.sqlFactory.newSQLGenerator();
        String query = gen.getQuery(selectStatement);
        CreateTest.assertEquals((Object)"SELECT MyIndex, MyName, MyDate, null AS virtCol FROM MySchema.MyTable", (Object)query);
    }
}

