/*
 * Decompiled with CFR 0.152.
 */
package at.newmedialab.ldpath.backend.sesame;

import at.newmedialab.ldpath.backend.sesame.AbstractSesameBackend;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SesameRepositoryBackend
extends AbstractSesameBackend {
    private Repository repository;

    protected SesameRepositoryBackend() {
    }

    public SesameRepositoryBackend(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Value createLiteral(String content) {
        return this.createLiteralInternal(this.repository.getValueFactory(), content);
    }

    public Value createLiteral(String content, Locale language, URI type) {
        return this.createLiteralInternal(this.repository.getValueFactory(), content, language, type);
    }

    public Value createURI(String uri) {
        return this.createURIInternal(this.repository.getValueFactory(), uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Value> listObjects(Value subject, Value property) {
        Collection<Value> collection;
        RepositoryConnection connection = this.repository.getConnection();
        try {
            connection.begin();
            collection = this.listObjectsInternal(connection, (Resource)subject, (org.openrdf.model.URI)property);
        }
        catch (Throwable throwable) {
            try {
                connection.commit();
                connection.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new RuntimeException("error while querying Sesame repository!", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Subject needs to be a URI or blank node, property a URI node (types: [subject: %s, property: %s])", this.debugType(subject), this.debugType(property)), e);
            }
        }
        connection.commit();
        connection.close();
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Value> listSubjects(Value property, Value object) {
        Collection<Value> collection;
        RepositoryConnection connection = this.repository.getConnection();
        try {
            connection.begin();
            collection = this.listSubjectsInternal(connection, (org.openrdf.model.URI)property, object);
        }
        catch (Throwable throwable) {
            try {
                connection.commit();
                connection.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new RuntimeException("error while querying Sesame repository!", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Property needs to be a URI node (property type: %s)", this.isURI(property) ? "URI" : (this.isBlank(property) ? "bNode" : "literal")), e);
            }
        }
        connection.commit();
        connection.close();
        return collection;
    }
}

