/*
 * Decompiled with CFR 0.152.
 */
package au.com.acegi.xmlformat;

import au.com.acegi.xmlformat.BlankLinesWriter;
import au.com.acegi.xmlformat.IOUtil;
import au.com.acegi.xmlformat.XmlOutputFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class FormatUtil {
    private static final String TMP_FILE_PREFIX = FormatUtil.class.getSimpleName();

    private FormatUtil() {
    }

    static void format(InputStream in, OutputStream out, XmlOutputFormat fmt) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document xmlDoc = reader.read(in);
        XMLWriter xmlWriter = FormatUtil.getXmlWriter(out, fmt);
        xmlWriter.write(xmlDoc);
        xmlWriter.flush();
    }

    private static XMLWriter getXmlWriter(OutputStream out, XmlOutputFormat fmt) throws UnsupportedEncodingException {
        BlankLinesWriter xmlWriter = fmt.isKeepBlankLines() ? new BlankLinesWriter(out, fmt) : new XMLWriter(out, (OutputFormat)fmt);
        return xmlWriter;
    }

    static boolean formatInPlace(File file, XmlOutputFormat fmt) throws DocumentException, IOException {
        if (file.length() == 0L) {
            return false;
        }
        File tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".xml");
        tmpFile.deleteOnExit();
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
            FormatUtil.format(in, out, fmt);
        }
        long hashFile = IOUtil.hash(file);
        long hashTmp = IOUtil.hash(tmpFile);
        if (hashFile == hashTmp) {
            return false;
        }
        Path source = tmpFile.toPath();
        Path target = file.toPath();
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    static boolean needsFormatting(File file, XmlOutputFormat fmt) throws DocumentException, IOException {
        if (file.length() == 0L) {
            return false;
        }
        File tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".xml");
        tmpFile.deleteOnExit();
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
            FormatUtil.format(in, out, fmt);
        }
        long hashFile = IOUtil.hash(file);
        long hashTmp = IOUtil.hash(tmpFile);
        return hashFile != hashTmp;
    }
}

