/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.feature.player;

import be.yildizgames.common.model.EntityId;
import be.yildizgames.common.model.PlayerId;
import be.yildizgames.engine.feature.player.PlayerRight;
import java.util.HashSet;
import java.util.Set;

public final class Player {
    public static final Player WORLD = new Player(PlayerId.WORLD, "world");
    public final PlayerId id;
    public final String name;
    public final PlayerRight role;
    private final Set<PlayerId> allies = new HashSet<PlayerId>();
    private final Set<EntityId> see = new HashSet<EntityId>();

    Player(PlayerId id, String name, PlayerRight role) {
        assert (id != null);
        assert (name != null);
        assert (role != null);
        this.id = id;
        this.name = name;
        this.role = role;
    }

    Player(PlayerId id, String name) {
        this(id, name, PlayerRight.PLAYER);
    }

    public void addAlly(Player ally) {
        this.allies.add(ally.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.name;
    }

    boolean isAlly(Player other) {
        return this.allies.contains(other.id);
    }

    public boolean see(EntityId id) {
        return this.see.add(id);
    }

    public boolean noLongerSee(EntityId id) {
        return this.see.remove(id);
    }

    public boolean isSeeing(EntityId id) {
        return this.see.contains(id);
    }
}

