/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.feature.player;

import be.yildizgames.common.exception.business.BusinessException;
import be.yildizgames.common.model.PlayerCreationListener;
import be.yildizgames.common.model.PlayerId;
import be.yildizgames.engine.feature.player.Player;
import be.yildizgames.engine.feature.player.PlayerProvider;
import be.yildizgames.engine.feature.player.PlayerRight;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class PlayerManager
implements PlayerProvider {
    private static final PlayerManager INSTANCE = new PlayerManager();
    private final Map<PlayerId, Player> playerIdList = new HashMap<PlayerId, Player>();
    private final Map<String, Player> playerNameList = new HashMap<String, Player>();
    private final List<PlayerCreationListener> playerCreationListeners = new ArrayList<PlayerCreationListener>();

    private PlayerManager() {
    }

    public static PlayerManager getInstance() {
        return INSTANCE;
    }

    public Player findFromId(PlayerId id) {
        return this.playerIdList.getOrDefault(id, Player.WORLD);
    }

    public Player getFromId(PlayerId id) {
        return Optional.ofNullable(this.playerIdList.get(id)).orElseThrow(() -> new PlayerNotFoundException(id + " not found"));
    }

    public Player getFromName(String name) {
        return Optional.ofNullable(this.playerNameList.get(name)).orElseThrow(() -> new PlayerNotFoundException(name + " not found"));
    }

    public boolean exists(PlayerId id) {
        return this.playerIdList.containsKey(id);
    }

    public Player createPlayer(PlayerId id, String name, PlayerRight right) {
        assert (id != null);
        assert (name != null);
        assert (right != null);
        if (this.playerNameList.containsKey(name)) {
            throw new ExistingPlayerException("A player already exists with name " + name);
        }
        if (this.playerIdList.containsKey(id)) {
            throw new ExistingPlayerException("A player already exists with id " + id);
        }
        Player player = new Player(id, name, right);
        this.playerIdList.put(id, player);
        this.playerNameList.put(name, player);
        this.playerCreationListeners.forEach(l -> l.playerCreated(player.id));
        return player;
    }

    public Player createPlayer(PlayerId id, String name) {
        return this.createPlayer(id, name, PlayerRight.PLAYER);
    }

    public PlayerRelation getRelation(Player player, Player other) {
        if (player.equals(other)) {
            return PlayerRelation.SAME;
        }
        if (player.isAlly(other)) {
            return PlayerRelation.ALLY;
        }
        return PlayerRelation.ENEMY;
    }

    @Override
    public List<Player> getPlayerList() {
        return new ArrayList<Player>(this.playerIdList.values());
    }

    public boolean isWorld(Player p) {
        return Player.WORLD.equals(p);
    }

    public boolean isWorld(PlayerId id) {
        return Player.WORLD.id.equals((Object)id);
    }

    public boolean isValid(PlayerId p1, PlayerId p2, PlayerRelation r) {
        return this.getRelation(this.getFromId(p1), this.getFromId(p2)).equals((Object)r);
    }

    public boolean isHostile(PlayerId p1, PlayerId p2) {
        return this.getRelation(this.getFromId(p1), this.getFromId(p2)).equals((Object)PlayerRelation.ENEMY);
    }

    public boolean exists(String name) {
        return this.playerNameList.containsKey(name);
    }

    public void addListener(PlayerCreationListener l) {
        this.playerCreationListeners.add(l);
    }

    public void clear() {
        this.playerIdList.clear();
        this.playerNameList.clear();
    }

    static final class PlayerNotFoundException
    extends BusinessException {
        PlayerNotFoundException(String message) {
            super(message);
        }
    }

    static final class ExistingPlayerException
    extends BusinessException {
        private static final long serialVersionUID = 1L;

        ExistingPlayerException(String message) {
            super(message);
        }
    }

    public static enum PlayerRelation {
        SAME,
        ENEMY,
        ALLY,
        NEUTRAL;

    }
}

