/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Datas;
import br.com.caelum.stella.boleto.Emissor;
import br.com.caelum.stella.boleto.EmissorToBeneficiarioMapper;
import br.com.caelum.stella.boleto.Pagador;
import br.com.caelum.stella.boleto.Sacado;
import br.com.caelum.stella.boleto.SacadoToPagadorMapper;
import br.com.caelum.stella.boleto.bancos.GeradorDeLinhaDigitavel;
import br.com.caelum.stella.boleto.exception.CriacaoBoletoException;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class Boleto
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected BigDecimal valorBoleto = BigDecimal.ZERO;
    protected BigDecimal quantidadeMoeda;
    protected BigDecimal valorMoeda;
    protected BigDecimal valorDescontos = BigDecimal.ZERO;
    protected BigDecimal valorDeducoes = BigDecimal.ZERO;
    protected BigDecimal valorMulta = BigDecimal.ZERO;
    protected BigDecimal valorAcrescimos = BigDecimal.ZERO;
    protected String especieMoeda;
    protected int codigoEspecieMoeda;
    protected String especieDocumento;
    protected String numeroDocumento;
    protected boolean aceite;
    protected Banco banco;
    protected Datas datas;
    protected Pagador pagador;
    protected Beneficiario beneficiario;
    protected List<String> instrucoes = Collections.emptyList();
    protected List<String> descricoes = Collections.emptyList();
    protected List<String> locaisDePagamento = Collections.emptyList();

    protected Boleto() {
    }

    public static Boleto novoBoleto() {
        return new Boleto().comEspecieMoeda("R$").comCodigoEspecieMoeda(9).comAceite(false).comEspecieDocumento("DV");
    }

    public boolean getAceite() {
        return this.aceite;
    }

    public Boleto comAceite(boolean aceite) {
        this.aceite = aceite;
        return this;
    }

    public Datas getDatas() {
        return this.datas;
    }

    public Boleto comDatas(Datas datas) {
        this.datas = datas;
        return this;
    }

    public String getEspecieDocumento() {
        return this.especieDocumento;
    }

    public Boleto comEspecieDocumento(String especieDocumento) {
        this.especieDocumento = especieDocumento;
        return this;
    }

    public String getNumeroDoDocumento() {
        return this.numeroDocumento;
    }

    public Boleto comNumeroDoDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
        return this;
    }

    public BigDecimal getQuantidadeDeMoeda() {
        return this.quantidadeMoeda;
    }

    public Boleto comQuantidadeMoeda(BigDecimal quantidadeMoeda) {
        this.quantidadeMoeda = quantidadeMoeda;
        return this;
    }

    public BigDecimal getValorBoleto() {
        return this.valorBoleto;
    }

    public Boleto comValorBoleto(double valor) {
        return this.comValorBoleto(Double.toString(valor));
    }

    public Boleto comValorBoleto(String valor) {
        return this.comValorBoleto(new BigDecimal(valor));
    }

    public Boleto comValorBoleto(BigDecimal valor) {
        this.valorBoleto = valor;
        return this;
    }

    public String getEspecieMoeda() {
        return this.especieMoeda;
    }

    public Boleto comEspecieMoeda(String especieMoeda) {
        this.especieMoeda = especieMoeda;
        return this;
    }

    public int getCodigoEspecieMoeda() {
        return this.codigoEspecieMoeda;
    }

    public Boleto comCodigoEspecieMoeda(int codigoEspecieMoeda) {
        this.codigoEspecieMoeda = codigoEspecieMoeda;
        return this;
    }

    public BigDecimal getValorMoeda() {
        return this.valorMoeda;
    }

    public Boleto comValorMoeda(BigDecimal valorMoeda) {
        this.valorMoeda = valorMoeda;
        return this;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public Boleto comBanco(Banco banco) {
        this.banco = banco;
        return this;
    }

    public Pagador getPagador() {
        return this.pagador;
    }

    public Boleto comPagador(Pagador pagador) {
        this.pagador = pagador;
        return this;
    }

    @Deprecated
    public Sacado getSacado() {
        return new SacadoToPagadorMapper().toSacado(this.pagador);
    }

    @Deprecated
    public Boleto comSacado(Sacado sacado) {
        this.pagador = new SacadoToPagadorMapper().toPagador(sacado);
        return this;
    }

    public Beneficiario getBeneficiario() {
        return this.beneficiario;
    }

    public Boleto comBeneficiario(Beneficiario beneficiario) {
        this.beneficiario = beneficiario;
        return this;
    }

    @Deprecated
    public Emissor getEmissor() {
        return new EmissorToBeneficiarioMapper().toEmissor(this.beneficiario);
    }

    @Deprecated
    public Boleto comEmissor(Emissor emissor) {
        this.beneficiario = new EmissorToBeneficiarioMapper().toBeneficiario(emissor);
        return this;
    }

    public List<String> getInstrucoes() {
        return this.instrucoes;
    }

    public Boleto comInstrucoes(String ... instrucoes) {
        if (instrucoes.length > 5) {
            throw new IllegalArgumentException("maximo de 5 instrucoes permitidas");
        }
        this.instrucoes = Arrays.asList(instrucoes);
        return this;
    }

    public List<String> getDescricoes() {
        return this.descricoes;
    }

    public Boleto comDescricoes(String ... descricoes) {
        if (descricoes.length > 5) {
            throw new IllegalArgumentException("maximo de 5 descricoes permitidas");
        }
        this.descricoes = Arrays.asList(descricoes);
        return this;
    }

    public Boleto comDescricao(String descricao) {
        if (descricao == null) {
            throw new IllegalArgumentException("nao e permitida descricao nula");
        }
        if (this.descricoes.size() == 5) {
            throw new UnsupportedOperationException("maximo de descricoes permitidas atingido");
        }
        this.descricoes.add(descricao);
        return this;
    }

    public List<String> getLocaisDePagamento() {
        return this.locaisDePagamento;
    }

    public Boleto comLocaisDePagamento(String ... locaisDePagamento) {
        if (locaisDePagamento.length > 2) {
            throw new IllegalArgumentException("maximo de 2 locais de pagamento permitidos");
        }
        this.locaisDePagamento = Arrays.asList(locaisDePagamento);
        return this;
    }

    public String getFatorVencimento() {
        Calendar dataBase = Calendar.getInstance();
        dataBase.set(5, 7);
        dataBase.set(2, 9);
        dataBase.set(1, 1997);
        dataBase.set(11, 0);
        dataBase.set(12, 0);
        dataBase.set(13, 0);
        dataBase.set(14, 0);
        Calendar vencimentoSemHoras = Calendar.getInstance();
        vencimentoSemHoras.set(5, this.datas.getVencimento().get(5));
        vencimentoSemHoras.set(2, this.datas.getVencimento().get(2));
        vencimentoSemHoras.set(1, this.datas.getVencimento().get(1));
        vencimentoSemHoras.set(11, 0);
        vencimentoSemHoras.set(12, 0);
        vencimentoSemHoras.set(13, 0);
        vencimentoSemHoras.set(14, 0);
        long diferencasEmMiliSegundos = vencimentoSemHoras.getTimeInMillis() - dataBase.getTimeInMillis();
        long diferencasEmDias = diferencasEmMiliSegundos / 86400000L;
        if (diferencasEmDias > 9999L) {
            throw new CriacaoBoletoException("Data fora do formato aceito!");
        }
        return String.valueOf((int)diferencasEmDias);
    }

    public String getValorFormatado() {
        return String.format("%011.2f", this.getValorBoleto()).replaceAll("[^0-9]", "");
    }

    public String getNumeroDoDocumentoFormatado() {
        return StellaStringUtils.leftPadWithZeros(this.numeroDocumento, 4);
    }

    public String getAgenciaECodigoBeneficiario() {
        return this.banco.getAgenciaECodigoBeneficiario(this.beneficiario);
    }

    public String getNossoNumeroECodDocumento() {
        return this.banco.getNossoNumeroECodigoDocumento(this);
    }

    public BigDecimal getValorDescontos() {
        return this.valorDescontos;
    }

    public Boleto comValorDescontos(String valorDescontos) {
        this.valorDescontos = new BigDecimal(valorDescontos);
        return this;
    }

    public BigDecimal getValorDeducoes() {
        return this.valorDeducoes;
    }

    public Boleto comValorDeducoes(String valorDeducoes) {
        this.valorDeducoes = new BigDecimal(valorDeducoes);
        return this;
    }

    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    public Boleto comValorMulta(String valorMulta) {
        this.valorMulta = new BigDecimal(valorMulta);
        return this;
    }

    public BigDecimal getValorAcrescimos() {
        return this.valorAcrescimos;
    }

    public Boleto comValorAcrescimos(String valorAcrescimos) {
        this.valorAcrescimos = new BigDecimal(valorAcrescimos);
        return this;
    }

    public BigDecimal getValorCobrado() {
        return this.valorBoleto.subtract(this.valorDescontos).subtract(this.valorDeducoes).add(this.valorMulta).add(this.valorAcrescimos);
    }

    public String getCodigoDeBarras() {
        return this.banco.geraCodigoDeBarrasPara(this);
    }

    public String getLinhaDigitavel() {
        return new GeradorDeLinhaDigitavel().geraLinhaDigitavelPara(this.getCodigoDeBarras(), this.banco);
    }

    public String getCarteira() {
        return this.banco.getCarteiraFormatado(this.beneficiario);
    }

    public String getLocalDePagamento() {
        return this.locaisDePagamento.isEmpty() ? "" : this.locaisDePagamento.get(0);
    }
}

