/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto;

import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.io.Serializable;

public class Endereco
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String logradouro;
    public String bairro;
    public String cep;
    public String cidade;
    public String uf;

    private Endereco() {
    }

    public Endereco(String logradouro, String bairro, String cep, String cidade, String uf) {
        this.logradouro = logradouro;
        this.bairro = bairro;
        this.cep = cep;
        this.cidade = cidade;
        this.uf = uf;
    }

    public String getEnderecoCompleto() {
        return StellaStringUtils.suffixNotNullStringOrDefault(this.logradouro, "", ", ") + StellaStringUtils.suffixNotNullStringOrDefault(this.bairro, "", " ") + StellaStringUtils.suffixNotNullStringOrDefault(this.cep, "", " - ") + StellaStringUtils.suffixNotNullStringOrDefault(this.cidade, "", " - ") + StellaStringUtils.suffixNotNullStringOrDefault(this.uf, "", "");
    }

    public String toString() {
        return this.getEnderecoCompleto();
    }

    public static Endereco novoEndereco() {
        return new Endereco();
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public Endereco comLogradouro(String logradouro) {
        this.logradouro = logradouro;
        return this;
    }

    public String getBairro() {
        return this.bairro;
    }

    public Endereco comBairro(String bairro) {
        this.bairro = bairro;
        return this;
    }

    public String getCep() {
        return this.cep;
    }

    public Endereco comCep(String cep) {
        this.cep = cep;
        return this;
    }

    public String getCidade() {
        return this.cidade;
    }

    public Endereco comCidade(String cidade) {
        this.cidade = cidade;
        return this;
    }

    public String getUf() {
        return this.uf;
    }

    public Endereco comUf(String uf) {
        this.uf = uf;
        return this;
    }
}

