/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;

public class Bradesco
extends AbstractBanco
implements Banco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_BRADESCO = "237";
    private static final String DIGITO_NUMERO_BRADESCO = "2";

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append(beneficiario.getAgenciaFormatada());
        campoLivre.append(this.getCarteiraFormatado(beneficiario));
        campoLivre.append(this.getNossoNumeroFormatado(beneficiario));
        campoLivre.append(this.getCodigoBeneficiarioFormatado(beneficiario));
        campoLivre.append("0");
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    @Override
    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNumeroFormatado()).append("-");
        return builder.append(DIGITO_NUMERO_BRADESCO).toString();
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_BRADESCO;
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 7);
    }

    @Override
    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCarteira(), 2);
    }

    @Override
    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getNossoNumero(), 11);
    }

    @Override
    public String getNossoNumeroECodigoDocumento(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        StringBuilder builder = new StringBuilder().append(StellaStringUtils.leftPadWithZeros(beneficiario.getCarteira(), 2));
        builder.append("/").append(this.getNossoNumeroFormatado(beneficiario));
        return builder.append(this.getDigitoNossoNumero(beneficiario)).toString();
    }

    private String getDigitoNossoNumero(Beneficiario beneficiario) {
        return beneficiario.getDigitoNossoNumero() != null && !beneficiario.getDigitoNossoNumero().isEmpty() ? "-" + beneficiario.getDigitoNossoNumero() : "";
    }
}

