/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;

public class Caixa
extends AbstractBanco
implements Banco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_CAIXA = "104";
    private static final String DIGITO_CAIXA = "0";

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        String carteiraDoEmissor = beneficiario.getCarteira();
        StringBuilder campoLivre = new StringBuilder();
        if (carteiraDoEmissor.equals("1")) {
            campoLivre.append(carteiraDoEmissor);
            campoLivre.append(StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 6));
            campoLivre.append(this.getNossoNumeroFormatado(beneficiario));
        } else if (carteiraDoEmissor.equals("2")) {
            String nossoNumeroCompleto = this.getNossoNumeroFormatado(beneficiario);
            campoLivre.append(StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 6));
            campoLivre.append(beneficiario.getDigitoCodigoBeneficiario());
            campoLivre.append(nossoNumeroCompleto.substring(2, 5));
            campoLivre.append(nossoNumeroCompleto.substring(0, 1));
            campoLivre.append(nossoNumeroCompleto.substring(5, 8));
            campoLivre.append(nossoNumeroCompleto.substring(1, 2));
            campoLivre.append(nossoNumeroCompleto.substring(8));
            campoLivre.append(this.geradorDeDigito.geraDigitoMod11(campoLivre.toString()));
        } else if (carteiraDoEmissor.equals("24")) {
            String nossoNumeroCompleto = this.getNossoNumeroFormatado(beneficiario);
            campoLivre.append(StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 6));
            campoLivre.append(beneficiario.getDigitoCodigoBeneficiario());
            campoLivre.append(nossoNumeroCompleto.substring(2, 5));
            campoLivre.append(nossoNumeroCompleto.substring(0, 1));
            campoLivre.append(nossoNumeroCompleto.substring(5, 8));
            campoLivre.append(nossoNumeroCompleto.substring(1, 2));
            campoLivre.append(nossoNumeroCompleto.substring(8));
            campoLivre.append(this.geradorDeDigito.geraDigitoMod11AceitandoRestoZero(campoLivre.toString()));
        } else {
            throw new IllegalArgumentException("A carteira digitada n\u00e3o \u00e9 suportada: " + carteiraDoEmissor);
        }
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    @Override
    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNumeroFormatado()).append("-");
        return builder.append(DIGITO_CAIXA).toString();
    }

    @Override
    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCarteira(), 2);
    }

    @Override
    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 5);
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getNossoNumero(), 17);
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_CAIXA;
    }

    @Override
    public String getNossoNumeroECodigoDocumento(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        String nn = this.getNossoNumeroFormatado(beneficiario);
        StringBuilder builder = new StringBuilder(nn);
        if (beneficiario.getDigitoNossoNumero() != null && !beneficiario.getDigitoNossoNumero().isEmpty()) {
            builder.append("-").append(beneficiario.getDigitoNossoNumero());
        }
        return builder.toString();
    }
}

