/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.exception.CriacaoBoletoException;

class CodigoDeBarrasBuilder {
    private StringBuilder codigoDeBarras;
    private Banco banco;

    CodigoDeBarrasBuilder(Boleto boleto) {
        this.banco = boleto.getBanco();
        this.codigoDeBarras = new StringBuilder(44);
        this.codigoDeBarras.append(this.banco.getNumeroFormatado());
        int codigoEspecieMoeda = boleto.getCodigoEspecieMoeda();
        this.codigoDeBarras.append(String.valueOf(codigoEspecieMoeda));
        this.codigoDeBarras.append(boleto.getFatorVencimento());
        this.codigoDeBarras.append(boleto.getValorFormatado());
    }

    public String comCampoLivre(StringBuilder campoLivre) {
        this.codigoDeBarras.append((CharSequence)campoLivre);
        String trecho = this.codigoDeBarras.toString();
        int digito = this.banco.getGeradorDeDigito().geraDigitoMod11(trecho);
        this.codigoDeBarras.insert(4, digito);
        this.validaTamahoDoCodigoDeBarrasCompletoGerado();
        return this.codigoDeBarras.toString();
    }

    private void validaTamahoDoCodigoDeBarrasCompletoGerado() {
        if (this.codigoDeBarras.toString().length() != 44) {
            throw new CriacaoBoletoException("Erro na gera\u00e7\u00e3o do c\u00f3digo de barras. N\u00famero de digitos diferente de 44. Verifique se todos os dados foram preenchidos corretamente.");
        }
    }
}

