/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class HSBC
extends AbstractBanco
implements Banco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_HSBC = "399";
    private static final String DIGITO_HSBC = "9";
    private static final String CODIGO_APLICATIVO = "2";

    @Override
    public String getNumeroFormatadoComDigito() {
        return "399-9";
    }

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        StringBuilder campoLivre = new StringBuilder();
        String codigoAgencia = boleto.getBeneficiario().getCodigoBeneficiario();
        campoLivre.append(StellaStringUtils.leftPadWithZeros(codigoAgencia, 7));
        campoLivre.append(this.getNossoNumeroFormatado(boleto.getBeneficiario()));
        campoLivre.append(this.getDataFormatoJuliano(boleto.getDatas().getVencimento(), 4));
        campoLivre.append(CODIGO_APLICATIVO);
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    public String getDataFormatoJuliano(Calendar vencimento, int tipo) {
        String result;
        Calendar dataLimite = Calendar.getInstance();
        dataLimite.set(5, 1);
        dataLimite.set(2, 6);
        dataLimite.set(1, 1997);
        if (vencimento.before(dataLimite)) {
            result = "0000";
        } else {
            int diaDoAno = vencimento.get(6);
            int digitoDoAno = vencimento.get(1) % 10;
            result = String.format("%03d%d", diaDoAno, digitoDoAno);
        }
        return result;
    }

    @Override
    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return "CNR";
    }

    @Override
    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 7);
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getNossoNumero(), 13);
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_HSBC;
    }

    @Override
    public String getAgenciaECodigoBeneficiario(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 7);
    }

    @Override
    public String getNossoNumeroECodigoDocumento(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        String nossoNumero = this.getNossoNumeroFormatado(beneficiario);
        String codigoBeneficiario = beneficiario.getCodigoBeneficiario();
        String dataVcto = new SimpleDateFormat("ddMMyy").format(boleto.getDatas().getVencimento().getTime());
        DigitoPara calculadorMod = this.getModuloNossoNumero(nossoNumero);
        String primeiroDigito = calculadorMod.calcula();
        String nossoNumeroComDigitos = nossoNumero + primeiroDigito + 4;
        long nossoNum = Long.parseLong(nossoNumeroComDigitos);
        long vcto = Long.parseLong(dataVcto);
        long benef = Long.parseLong(codigoBeneficiario);
        String somatorio = String.valueOf(nossoNum + benef + vcto);
        DigitoPara calculadorMod2 = this.getModuloNossoNumero(somatorio);
        String segundoDigito = calculadorMod2.calcula();
        return nossoNumeroComDigitos + segundoDigito;
    }

    private DigitoPara getModuloNossoNumero(String nossoNumero) {
        return new DigitoPara(nossoNumero).trocandoPorSeEncontrar("0", new Integer[]{10, 11}).comMultiplicadores(new Integer[]{9, 8, 7, 6, 5, 4, 3, 2}).mod(11);
    }
}

