/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;

public class Itau
extends AbstractBanco
implements Banco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_ITAU = "341";
    private static final String DIGITO_ITAU = "7";

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append(this.getCarteiraFormatado(beneficiario));
        campoLivre.append(this.getNossoNumeroFormatado(beneficiario));
        campoLivre.append(beneficiario.getAgenciaFormatada());
        campoLivre.append(this.getCodigoBeneficiarioFormatado(beneficiario)).append("000");
        campoLivre.insert(20, this.geradorDeDigito.geraDigitoMod10(campoLivre.substring(11, 20)));
        campoLivre.insert(11, this.geradorDeDigito.geraDigitoMod10(campoLivre.substring(11, 20).concat(campoLivre.substring(0, 11))));
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    @Override
    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNumeroFormatado()).append("-");
        return builder.append(DIGITO_ITAU).toString();
    }

    @Override
    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCarteira(), 3);
    }

    @Override
    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 5);
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getNossoNumero(), 8);
    }

    @Override
    public String getNossoNumeroECodigoDocumento(Boleto boleto) {
        String valor = super.getNossoNumeroECodigoDocumento(boleto);
        Beneficiario beneficiario = boleto.getBeneficiario();
        return valor.concat("-").concat(beneficiario.getDigitoNossoNumero());
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_ITAU;
    }

    @Override
    public String getAgenciaECodigoBeneficiario(Beneficiario beneficiario) {
        StringBuilder builder = new StringBuilder();
        builder.append(beneficiario.getAgenciaFormatada()).append("/");
        builder.append(this.getCodigoBeneficiarioFormatado(beneficiario));
        builder.append(StellaStringUtils.prefixNotNullStringOrDefault(beneficiario.getDigitoCodigoBeneficiario(), "", "-"));
        return builder.toString();
    }
}

